/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.jackson;

import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.enums.Enums;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;

public class DetailEnumDeserializer
extends JsonDeserializer<DetailEnum<?>>
implements ContextualDeserializer {
    private Class<DetailEnum<?>> enumClass;

    public DetailEnumDeserializer() {
    }

    public DetailEnumDeserializer(Class<DetailEnum<?>> enumClass) {
        this.enumClass = enumClass;
    }

    public DetailEnum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode jn;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String value = null;
        value = node.isObject() ? ((jn = node.get("value")) != null ? jn.asText() : value) : node.asText();
        return Enums.deserialize(this.enumClass, value, !ctxt.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS));
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        return new DetailEnumDeserializer(ctxt.getContextualType().getRawClass());
    }
}

