/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.jackson;

import com.easycodebox.common.validate.Assert;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class Jacksons
extends ObjectMapper {
    private static final long serialVersionUID = -7195120894069424979L;
    public static Jacksons SIMPLE = Jacksons.simpleSetting(Jacksons.instance()).global(true);
    public static Jacksons NON_NULL = Jacksons.nonNullSetting(Jacksons.instance()).global(true);
    public static Jacksons COMMUNICATE = Jacksons.communicateSetting(Jacksons.instance()).global(true);
    private boolean global = false;

    private Jacksons() {
    }

    private Jacksons(Jacksons src) {
        super((ObjectMapper)src);
    }

    public static Jacksons instance() {
        return new Jacksons();
    }

    public Jacksons copy() {
        this._checkInvalidCopy(Jacksons.class);
        return new Jacksons(this);
    }

    public static Jacksons simple() {
        return Jacksons.simpleSetting(SIMPLE.copy());
    }

    public static Jacksons nonNull() {
        return Jacksons.nonNullSetting(NON_NULL.copy());
    }

    public static Jacksons communicate() {
        return Jacksons.communicateSetting(COMMUNICATE.copy());
    }

    public static Jacksons simpleSetting(Jacksons mapper) {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    public static Jacksons nonNullSetting(Jacksons mapper) {
        Jacksons.simpleSetting(mapper);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    public static Jacksons communicateSetting(Jacksons mapper) {
        Jacksons.nonNullSetting(mapper);
        mapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        return mapper;
    }

    public Jacksons exclude(Class<?> dataType, String ... propertyArray) {
        this.validate();
        HashSet<String> properties = new HashSet<String>(propertyArray.length);
        Collections.addAll(properties, propertyArray);
        return this.exclude(dataType, properties);
    }

    public Jacksons exclude(Class<?> dataType, Set<String> properties) {
        this.validate();
        SimpleFilterProvider fp = new SimpleFilterProvider().addFilter(dataType.getName(), (SimpleBeanPropertyFilter)new SimpleBeanPropertyFilter.SerializeExceptFilter(properties)).setFailOnUnknownId(false);
        this.setFilters((FilterProvider)fp);
        this.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public Object findFilterId(Annotated a) {
                Object filterId = super.findFilterId(a);
                return filterId == null ? a.getName() : filterId;
            }
        });
        return this;
    }

    public Jacksons include(Class<?> dataType, String ... propertyArray) {
        this.validate();
        HashSet<String> properties = new HashSet<String>(propertyArray.length);
        Collections.addAll(properties, propertyArray);
        return this.include(dataType, properties);
    }

    public Jacksons include(Class<?> dataType, Set<String> properties) {
        this.validate();
        SimpleFilterProvider fp = new SimpleFilterProvider().addFilter(dataType.getName(), (SimpleBeanPropertyFilter)new SimpleBeanPropertyFilter.FilterExceptFilter(properties)).setFailOnUnknownId(false);
        this.setFilters((FilterProvider)fp);
        this.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public Object findFilterId(Annotated a) {
                Object filterId = super.findFilterId(a);
                return filterId == null ? a.getName() : filterId;
            }
        });
        return this;
    }

    public <T> Jacksons addJsonSerializer(Class<? extends T> type, JsonSerializer<T> jsonSerializer) {
        this.validate();
        SimpleSerializers sers = new SimpleSerializers();
        sers.addSerializer(type, jsonSerializer);
        this._serializerFactory = this._serializerFactory.withAdditionalSerializers((Serializers)sers);
        return this;
    }

    public String toJson(Object value) throws JsonProcessingException {
        return value == null ? "null" : this.writerWithView(value.getClass()).writeValueAsString(value);
    }

    public <T> T toBean(String value, Class<T> valueType) throws JsonProcessingException, IOException {
        return (T)this.reader(valueType).readValue(value);
    }

    public <T> T toBean(String value, TypeReference<T> valueType) throws JsonProcessingException, IOException {
        return (T)this.reader(valueType).readValue(value);
    }

    private void validate() {
        Assert.isFalse(this.global, "\u5168\u5c40\u5171\u4eab\u53d8\u91cf\u4e0d\u80fd\u914d\u7f6e\u65b0\u7279\u6027", new Object[0]);
    }

    private Jacksons global(boolean global) {
        this.global = global;
        return this;
    }

    public ObjectMapper enableDefaultTyping() {
        this.validate();
        return super.enableDefaultTyping();
    }

    public ObjectMapper enableDefaultTyping(ObjectMapper.DefaultTyping dti) {
        this.validate();
        return super.enableDefaultTyping(dti);
    }

    public ObjectMapper enableDefaultTyping(ObjectMapper.DefaultTyping applicability, JsonTypeInfo.As includeAs) {
        this.validate();
        return super.enableDefaultTyping(applicability, includeAs);
    }

    public ObjectMapper enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping applicability, String propertyName) {
        this.validate();
        return super.enableDefaultTypingAsProperty(applicability, propertyName);
    }

    public ObjectMapper disableDefaultTyping() {
        this.validate();
        return super.disableDefaultTyping();
    }

    public ObjectMapper configure(MapperFeature f, boolean state) {
        this.validate();
        return super.configure(f, state);
    }

    public ObjectMapper enable(MapperFeature ... f) {
        this.validate();
        return super.enable(f);
    }

    public ObjectMapper disable(MapperFeature ... f) {
        this.validate();
        return super.disable(f);
    }

    public ObjectMapper configure(SerializationFeature f, boolean state) {
        this.validate();
        return super.configure(f, state);
    }

    public ObjectMapper enable(SerializationFeature f) {
        this.validate();
        return super.enable(f);
    }

    public ObjectMapper enable(SerializationFeature first, SerializationFeature ... f) {
        this.validate();
        return super.enable(first, f);
    }

    public ObjectMapper disable(SerializationFeature f) {
        this.validate();
        return super.disable(f);
    }

    public ObjectMapper disable(SerializationFeature first, SerializationFeature ... f) {
        this.validate();
        return super.disable(first, f);
    }

    public ObjectMapper configure(DeserializationFeature f, boolean state) {
        this.validate();
        return super.configure(f, state);
    }

    public ObjectMapper enable(DeserializationFeature feature) {
        this.validate();
        return super.enable(feature);
    }

    public ObjectMapper enable(DeserializationFeature first, DeserializationFeature ... f) {
        this.validate();
        return super.enable(first, f);
    }

    public ObjectMapper disable(DeserializationFeature feature) {
        this.validate();
        return super.disable(feature);
    }

    public ObjectMapper disable(DeserializationFeature first, DeserializationFeature ... f) {
        this.validate();
        return super.disable(first, f);
    }

    public ObjectMapper configure(JsonParser.Feature f, boolean state) {
        this.validate();
        return super.configure(f, state);
    }

    public ObjectMapper configure(JsonGenerator.Feature f, boolean state) {
        this.validate();
        return super.configure(f, state);
    }

    public ObjectMapper enable(JsonParser.Feature ... features) {
        this.validate();
        return super.enable(features);
    }

    public ObjectMapper enable(JsonGenerator.Feature ... features) {
        this.validate();
        return super.enable(features);
    }

    public ObjectMapper disable(JsonParser.Feature ... features) {
        this.validate();
        return super.disable(features);
    }

    public ObjectMapper disable(JsonGenerator.Feature ... features) {
        this.validate();
        return super.disable(features);
    }

    public ObjectMapper registerModule(Module module) {
        this.validate();
        return super.registerModule(module);
    }

    public ObjectMapper registerModules(Module ... modules) {
        this.validate();
        return super.registerModules(modules);
    }

    public ObjectMapper registerModules(Iterable<Module> modules) {
        this.validate();
        return super.registerModules(modules);
    }

    public ObjectMapper setSerializerFactory(SerializerFactory f) {
        this.validate();
        return super.setSerializerFactory(f);
    }

    public ObjectMapper setSerializerProvider(DefaultSerializerProvider p) {
        this.validate();
        return super.setSerializerProvider(p);
    }

    public ObjectMapper setMixIns(Map<Class<?>, Class<?>> sourceMixins) {
        this.validate();
        return super.setMixIns(sourceMixins);
    }

    public ObjectMapper addMixIn(Class<?> target, Class<?> mixinSource) {
        this.validate();
        return super.addMixIn(target, mixinSource);
    }

    public void setVisibilityChecker(VisibilityChecker<?> vc) {
        this.validate();
        super.setVisibilityChecker(vc);
    }

    public ObjectMapper setVisibility(PropertyAccessor forMethod, JsonAutoDetect.Visibility visibility) {
        this.validate();
        return super.setVisibility(forMethod, visibility);
    }

    public ObjectMapper setSubtypeResolver(SubtypeResolver str) {
        this.validate();
        return super.setSubtypeResolver(str);
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector ai) {
        this.validate();
        return super.setAnnotationIntrospector(ai);
    }

    public ObjectMapper setAnnotationIntrospectors(AnnotationIntrospector serializerAI, AnnotationIntrospector deserializerAI) {
        this.validate();
        return super.setAnnotationIntrospectors(serializerAI, deserializerAI);
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy s) {
        this.validate();
        return super.setPropertyNamingStrategy(s);
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include incl) {
        this.validate();
        return super.setSerializationInclusion(incl);
    }

    public ObjectMapper setDefaultTyping(TypeResolverBuilder<?> typer) {
        this.validate();
        return super.setDefaultTyping(typer);
    }

    public void registerSubtypes(Class<?> ... classes) {
        this.validate();
        super.registerSubtypes((Class[])classes);
    }

    public void registerSubtypes(NamedType ... types) {
        this.validate();
        super.registerSubtypes(types);
    }

    public ObjectMapper setTypeFactory(TypeFactory f) {
        this.validate();
        return super.setTypeFactory(f);
    }

    public ObjectMapper setNodeFactory(JsonNodeFactory f) {
        this.validate();
        return super.setNodeFactory(f);
    }

    public ObjectMapper addHandler(DeserializationProblemHandler h) {
        this.validate();
        return super.addHandler(h);
    }

    public ObjectMapper setConfig(DeserializationConfig config) {
        this.validate();
        return super.setConfig(config);
    }

    public void setFilters(FilterProvider filterProvider) {
        this.validate();
        super.setFilters(filterProvider);
    }

    public ObjectMapper setBase64Variant(Base64Variant v) {
        this.validate();
        return super.setBase64Variant(v);
    }

    public ObjectMapper setConfig(SerializationConfig config) {
        this.validate();
        return super.setConfig(config);
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        this.validate();
        return super.setDateFormat(dateFormat);
    }

    public Object setHandlerInstantiator(HandlerInstantiator hi) {
        this.validate();
        return super.setHandlerInstantiator(hi);
    }

    public ObjectMapper setInjectableValues(InjectableValues injectableValues) {
        this.validate();
        return super.setInjectableValues(injectableValues);
    }

    public ObjectMapper setLocale(Locale l) {
        this.validate();
        return super.setLocale(l);
    }

    public ObjectMapper setTimeZone(TimeZone tz) {
        this.validate();
        return super.setTimeZone(tz);
    }

    public void acceptJsonFormatVisitor(Class<?> type, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        this.validate();
        super.acceptJsonFormatVisitor(type, visitor);
    }

    public void acceptJsonFormatVisitor(JavaType type, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        this.validate();
        super.acceptJsonFormatVisitor(type, visitor);
    }
}

