/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.lang.DataTypeUtils;
import com.easycodebox.common.lang.DateUtils;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.lang.reflect.ClassUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.beanutils.BeanUtils;

public class DataConvert {
    private static final Logger LOG = LoggerFactory.getLogger(DataConvert.class);
    public static final String separator = ",";

    public static <T> T[] convertArray(String obj, Class<T[]> clazz, String separator) throws BaseException {
        if (StringUtils.isBlank((String)obj)) {
            throw new BaseException("obj is null.", new Object[0]);
        }
        if (StringUtils.isBlank((String)separator)) {
            separator = separator;
        }
        String[] s = obj.replaceAll("[\\[\\]]", "").split(separator);
        return DataConvert.convertArray(s, clazz);
    }

    public static <T> T[] convertArray(String obj, Class<T[]> clazz) throws BaseException {
        return DataConvert.convertArray(obj, clazz, separator);
    }

    public static <T> T[] convertArray(String[] objs, Class<T[]> clazz) throws BaseException {
        if (objs == null) {
            return null;
        }
        if (clazz == Object[].class) {
            return objs;
        }
        Object[] copy = (Object[])Array.newInstance(clazz.getComponentType(), objs.length);
        int i = 0;
        for (String temp : objs) {
            copy[i++] = DataConvert.convertType(temp, clazz.getComponentType());
        }
        return copy;
    }

    public static <T> T convertType(String obj, Class<T> clazz) throws BaseException {
        return DataConvert.convertType(obj, clazz, null);
    }

    public static <T> T convertType(String obj, Class<T> clazz, String separator) throws BaseException {
        if (clazz == null) {
            throw new BaseException("you except convert type is null.", new Object[0]);
        }
        if (obj == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)obj;
        }
        obj = obj.trim().replaceAll("^['\"]*([^'\"]*)['\"]*$", "$1");
        Object t = null;
        if (clazz.isArray()) {
            if (StringUtils.isBlank((String)separator)) {
                separator = separator;
            }
            String[] os = obj.replaceAll("[\\[\\]]", "").split(separator);
            t = Array.newInstance(clazz.getComponentType(), os.length);
            int i = 0;
            for (String temp : os) {
                Array.set(t, i++, DataConvert.convertType(temp, clazz.getComponentType()));
            }
        } else if (Number.class.isAssignableFrom(clazz = ClassUtils.primitiveToWrapper(clazz))) {
            try {
                Constructor c = clazz.getConstructor(String.class);
                t = c.newInstance(obj);
            }
            catch (Exception c) {}
        } else if (DetailEnum.class.isAssignableFrom(clazz)) {
            boolean handled = false;
            String handledVal = obj;
            for (Object e : clazz.getEnumConstants()) {
                DetailEnum enumVal = (DetailEnum)e;
                Object val = enumVal.getValue();
                if (!handled && !val.getClass().isAssignableFrom(String.class)) {
                    handledVal = DataConvert.convertType(obj, val.getClass());
                }
                if (!handledVal.equals(val)) continue;
                t = e;
                break;
            }
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Enum en;
            boolean suc = false;
            for (Object e : clazz.getEnumConstants()) {
                en = (Enum)e;
                String name = en.name();
                if (!name.equals(obj)) continue;
                t = e;
                suc = true;
                break;
            }
            if (!suc && obj.matches("[0-9]+")) {
                for (Object e : clazz.getEnumConstants()) {
                    en = (Enum)e;
                    int index = en.ordinal();
                    if (Integer.parseInt(obj) != index) continue;
                    t = e;
                    suc = true;
                    break;
                }
            }
        } else {
            t = Date.class.isAssignableFrom(clazz) ? (StringUtils.isBlank((String)obj) ? null : (StringUtils.isNumeric((String)obj) ? new Date(Long.parseLong(obj)) : DateUtils.parse(obj))) : (Calendar.class.isAssignableFrom(clazz) ? DateUtils.parse2Calenar(obj.toString()) : (Boolean.class.isAssignableFrom(clazz) ? new Boolean(obj) : obj));
        }
        return (T)t;
    }

    public static <T> String arrayCollection2Str(Object data, String separator, String prefix, String postfix, boolean forceOneVal, String ... props) {
        if (data == null) {
            return "";
        }
        if (!data.getClass().isArray() && !(data instanceof Collection)) {
            throw new IllegalArgumentException("data is not array or collection");
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (data.getClass().isArray()) {
            int length = Array.getLength(data);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(data, i);
                if (o.getClass().isArray() || o instanceof Collection) {
                    sb.append(DataConvert.arrayCollection2Str(o, separator, prefix, postfix, forceOneVal, props));
                } else {
                    sb.append(DataConvert.Object2String(o, forceOneVal, props));
                }
                if (i >= length - 1) continue;
                sb.append(separator);
            }
        } else if (data instanceof Collection) {
            Collection c = (Collection)data;
            Iterator it = c.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object o = it.next();
                if (o.getClass().isArray() || o instanceof Collection) {
                    sb.append(DataConvert.arrayCollection2Str(o, separator, prefix, postfix, forceOneVal, props));
                } else {
                    sb.append(DataConvert.Object2String(o, forceOneVal, props));
                }
                if (i < c.size() - 1) {
                    sb.append(separator);
                }
                ++i;
            }
        }
        if (postfix != null) {
            sb.append(postfix);
        }
        return sb.toString();
    }

    public static <T> String array2String(T[] data, String separator, String prefix, String postfix, boolean forceOneVal, String ... props) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        for (int i = 0; i < data.length; ++i) {
            sb.append(DataConvert.Object2String(data[i], forceOneVal, props));
            if (i >= data.length - 1) continue;
            sb.append(separator);
        }
        if (postfix != null) {
            sb.append(postfix);
        }
        return sb.toString();
    }

    public static String Object2String(Object data, boolean forceOneVal, String ... props) {
        if (data == null) {
            return "";
        }
        if (data.getClass().isArray() || data instanceof Collection) {
            throw new IllegalArgumentException("data \u53c2\u6570\u4e0d\u80fd\u4e3a\u96c6\u5408");
        }
        StringBuilder sb = new StringBuilder();
        if (forceOneVal) {
            if (!DataTypeUtils.isBasicType(data) && props != null && props.length > 0 && props[0] != null) {
                try {
                    sb.append(BeanUtils.getProperty((Object)data, (String)props[0]));
                }
                catch (Exception e) {
                    LOG.error((Object)"\u83b7\u53d6\u5c5e\u6027\u503c\u9519\u8bef", e);
                }
            } else {
                sb.append(data.toString());
            }
        } else if (DataTypeUtils.isBasicType(data)) {
            sb.append(data.toString());
        } else {
            sb.append("{");
            if (props != null && props.length > 0 && props[0] != null) {
                for (int j = 0; j < props.length; ++j) {
                    try {
                        sb.append(props[j]).append(":").append(BeanUtils.getProperty((Object)data, (String)props[j]));
                        if (j >= props.length - 1) continue;
                        sb.append(separator);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"\u83b7\u53d6\u5c5e\u6027\u503c\u9519\u8bef", e);
                    }
                }
            }
            sb.append("}");
        }
        return sb.toString();
    }
}

