/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATETIME_FMT_STR = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FMT_STR = "yyyy-MM-dd";
    public static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Calendar parse2Calenar(String date) {
        return DateUtils.parse2Calenar(date, DATETIME_FMT_STR);
    }

    public static Calendar parse2Calenar(String date, String formater) {
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(new SimpleDateFormat(formater).parse(date));
        }
        catch (ParseException e) {
            LOG.error((Object)"parse2Calenar method has error.", e);
            return null;
        }
        return c;
    }

    public static Date parse(String date) {
        return DateUtils.parse(date, DATETIME_FMT_STR);
    }

    public static Date parse(String date, String formater) {
        if (StringUtils.isBlank((String)formater) || StringUtils.isBlank((String)date)) {
            throw new IllegalArgumentException("date or formater is IllegalArgument.");
        }
        Date fd = null;
        try {
            fd = new SimpleDateFormat(formater).parse(date);
        }
        catch (ParseException e) {
            LOG.error((Object)"parse Date Exception.", e);
            return null;
        }
        return fd;
    }

    public static String format(Date d, String formater) {
        if (formater == null) {
            throw new BaseException("formater is null.", new Object[0]);
        }
        if (d == null) {
            throw new BaseException("date is null.", new Object[0]);
        }
        return new SimpleDateFormat(formater).format(d);
    }

    public static String format(Date d) {
        if (d == null) {
            throw new BaseException("date is null.", new Object[0]);
        }
        return DATE_FMT.format(d);
    }

    public static Date format2Date(Date d, String formater) {
        if (d == null) {
            throw new BaseException("date is null.", new Object[0]);
        }
        String fmt_str = DateUtils.format(d, formater);
        return DateUtils.parse(fmt_str, formater);
    }

    public static Date[] surplusDayOfMonth() {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c2.add(2, 1);
        c2.set(5, 0);
        Date beginDate = DateUtils.format2Date(c1.getTime(), DATE_FMT_STR);
        Date endDate = DateUtils.format2Date(c2.getTime(), DATE_FMT_STR);
        return new Date[]{beginDate, endDate};
    }

    public static Date[] getCurrentDayRange() {
        GregorianCalendar begin = new GregorianCalendar();
        Calendar end = (Calendar)((Calendar)begin).clone();
        begin.set(11, 0);
        begin.set(12, 0);
        begin.set(13, 0);
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        return new Date[]{begin.getTime(), end.getTime()};
    }

    public static Date[] getDayRange(Date date) {
        Calendar begin = Calendar.getInstance();
        begin.setTime(date);
        Calendar end = (Calendar)begin.clone();
        begin.set(11, 0);
        begin.set(12, 0);
        begin.set(13, 0);
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        return new Date[]{begin.getTime(), end.getTime()};
    }

    public static Date[] getDayRange(Date begin, Date end) {
        if (begin.after(end)) {
            throw new BaseException("param begin(Date) is after end(Date). This is invalid.", new Object[0]);
        }
        Calendar bc = Calendar.getInstance();
        bc.setTime(begin);
        Calendar ec = Calendar.getInstance();
        ec.setTime(end);
        bc.set(11, 0);
        bc.set(12, 0);
        bc.set(13, 0);
        ec.set(11, 23);
        ec.set(12, 59);
        ec.set(13, 59);
        return new Date[]{bc.getTime(), ec.getTime()};
    }

    public static Date scrableDate(Date date, Date time) {
        String d = DateUtils.format(date, DATE_FMT_STR);
        String t = DateUtils.format(time, "HH:mm:ss");
        return DateUtils.parse(d + " " + t);
    }

    public static Date add(Date date, int field, int amount) {
        Calendar cur = Calendar.getInstance();
        cur.setTime(date);
        cur.add(field, amount);
        return cur.getTime();
    }

    public static Date add(int field, int amount) {
        Calendar cur = Calendar.getInstance();
        cur.add(field, amount);
        return cur.getTime();
    }

    public static int addAndCompare(Date compared, int field, int amount) {
        return DateUtils.add(field, amount).compareTo(compared);
    }

    public static int addAndCompare(Date date, Date compared, int field, int amount) {
        return DateUtils.add(date, field, amount).compareTo(compared);
    }

    public static Date getWeekStart() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setFirstDayOfWeek(2);
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        currentDate.set(7, 2);
        return currentDate.getTime();
    }

    public static Date getWeekEnd() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setFirstDayOfWeek(2);
        currentDate.set(11, 23);
        currentDate.set(12, 59);
        currentDate.set(13, 59);
        currentDate.set(7, 1);
        return currentDate.getTime();
    }

    public static Date getMonthStart() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getMonthEnd() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        ((Calendar)calendar).roll(5, -1);
        return calendar.getTime();
    }

    public static Date getDayStart(Date d) {
        String str = DateUtils.format(d, "yyyy-MM-dd ") + "00:00:00";
        return DateUtils.parse(str, DATETIME_FMT_STR);
    }

    public static Date getDayEnd(Date d) {
        String str = DateUtils.format(d, "yyyy-MM-dd ") + "23:59:59";
        return DateUtils.parse(str, DATETIME_FMT_STR);
    }

    public static Date addDate(Date date, int field, int amount) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.add(field, amount);
        return cld.getTime();
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getDayEnd(new Date()));
    }

    public static Date[] getMondayAndSundayByDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayofweek = c.get(7) - 1;
        if (dayofweek == 0) {
            dayofweek = 7;
        }
        c.add(5, -dayofweek + 1);
        Date startDate = c.getTime();
        c = Calendar.getInstance();
        c.setTime(date);
        dayofweek = c.get(7) - 1;
        if (dayofweek == 0) {
            dayofweek = 7;
        }
        c.add(5, -dayofweek + 7);
        Date endDate = c.getTime();
        return DateUtils.getDayRange(startDate, endDate);
    }

    public static Date getDateByms(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar.getTime();
    }
}

