/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;

public class DecimalUtils {
    public static String fmt(Object data, int digit) {
        return DecimalUtils.fmt(data, digit, false);
    }

    public static String fmt(Object data, int digit, boolean removeZero) {
        if (data == null) {
            return "";
        }
        DecimalFormat df = DecimalUtils.obatainDecimalFormat(digit, removeZero);
        if (!(data instanceof Number)) {
            data = new BigDecimal(data.toString());
        }
        return df.format(data);
    }

    public static String fmtMul(Object data, Object mul, int digit, boolean removeZero) {
        if (data == null || mul == null) {
            return "";
        }
        DecimalFormat df = DecimalUtils.obatainDecimalFormat(digit, removeZero);
        return df.format(new BigDecimal(data.toString()).multiply(new BigDecimal(mul.toString())));
    }

    public static String fmtDiv(Object data, Object divide, int digit, boolean removeZero) {
        if (data == null || divide == null) {
            return "";
        }
        DecimalFormat df = DecimalUtils.obatainDecimalFormat(digit, removeZero);
        return df.format(new BigDecimal(data.toString()).divide(new BigDecimal(divide.toString())));
    }

    public static String fmtAdd(Object data, Object add, int digit, boolean removeZero) {
        if (data == null || add == null) {
            return "";
        }
        DecimalFormat df = DecimalUtils.obatainDecimalFormat(digit, removeZero);
        return df.format(new BigDecimal(data.toString()).add(new BigDecimal(add.toString())));
    }

    public static String fmtSub(Object data, Object subtract, int digit, boolean removeZero) {
        if (data == null || subtract == null) {
            return "";
        }
        DecimalFormat df = DecimalUtils.obatainDecimalFormat(digit, removeZero);
        return df.format(new BigDecimal(data.toString()).subtract(new BigDecimal(subtract.toString())));
    }

    private static DecimalFormat obatainDecimalFormat(int digit, boolean removeZero) {
        String decimalFmt = "";
        decimalFmt = removeZero ? StringUtils.repeat((String)"#", (int)digit) : StringUtils.repeat((String)"0", (int)digit);
        if (decimalFmt.length() > 0) {
            decimalFmt = "." + decimalFmt;
        }
        DecimalFormat df = new DecimalFormat("0" + decimalFmt);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df;
    }

    public static BigDecimal scale(BigDecimal dec, int scale) {
        if (dec == null) {
            return null;
        }
        return dec.setScale(scale, 4);
    }
}

