/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import com.easycodebox.common.Copyable;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.lang.SerializationUtils;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.lang.reflect.ClassUtils;
import com.easycodebox.common.lang.reflect.FieldUtils;
import com.easycodebox.common.lang.reflect.MethodUtils;
import com.easycodebox.common.validate.Assert;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cglib.beans.BeanCopier;

public abstract class ObjectUtils
extends org.apache.commons.lang.ObjectUtils {
    private static final ConcurrentHashMap<Class<?>, BeanCopier> BEAN_COPIERS = new ConcurrentHashMap();
    private static final Set<Class<?>> PRIMITIVES_AND_WRAPPERS = new HashSet();
    private static final Set<Class<?>> IMMUTABLE_CLASSES;

    public static final <T> boolean isEquals(T lhs, T rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public static boolean isArray(Object array) {
        if (array == null) {
            return false;
        }
        return array.getClass().isArray();
    }

    public static boolean isCloneable(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (!Cloneable.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Method method = MethodUtils.findPublicMethod(clazz, "clone", new Class[0]);
        return method != null;
    }

    public static boolean isPrimitiveOrWrapper(Object obj) {
        if (obj == null) {
            return false;
        }
        return PRIMITIVES_AND_WRAPPERS.contains(obj.getClass());
    }

    public static boolean isArrayOfPrimitives(Object array) {
        if (array == null) {
            return false;
        }
        Class<?> clazz = array.getClass();
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isArrayOfPrimitivesOrWrappers(Object array) {
        if (array == null) {
            return false;
        }
        Class<?> clazz = array.getClass();
        return clazz.isArray() && PRIMITIVES_AND_WRAPPERS.contains(clazz);
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return null;
        }
        if (Void.TYPE == clazz) {
            return null;
        }
        if (Boolean.TYPE == clazz) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        throw new RuntimeException("assertion failed, should not reach here, clazz: " + clazz);
    }

    public static Object copy(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (ObjectUtils.isPrimitiveOrWrapper(obj)) {
            return obj;
        }
        if (IMMUTABLE_CLASSES.contains(clazz)) {
            return obj;
        }
        if (ObjectUtils.isArray(obj)) {
            return ObjectUtils.arrayCopy(obj);
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return ObjectUtils.setCopy((Set)obj);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return ObjectUtils.mapCopy((Map)obj);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ObjectUtils.listCopy((List)obj);
        }
        if (Copyable.class.isAssignableFrom(clazz)) {
            return ((Copyable)obj).copy();
        }
        if (Cloneable.class.isAssignableFrom(clazz) && ObjectUtils.isCloneable(obj)) {
            return ObjectUtils.cloneCopy(obj);
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return SerializationUtils.copy((Serializable)obj);
        }
        try {
            Object r = clazz.newInstance();
            ObjectUtils.copy(obj, r);
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to copy " + obj, e);
        }
    }

    public static Object arrayCopy(Object array) {
        if (!ObjectUtils.isArray(array)) {
            throw new IllegalArgumentException("parameter array is not an Array");
        }
        int length = Array.getLength(array);
        Object r = Array.newInstance(array.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (ObjectUtils.isArray(element)) {
                Array.set(r, i, ObjectUtils.arrayCopy(element));
                continue;
            }
            Array.set(r, i, ObjectUtils.copy(element));
        }
        return r;
    }

    public static Object setCopy(Set set) {
        if (set == null) {
            return null;
        }
        try {
            Set r = (Set)set.getClass().newInstance();
            for (Object obj : set) {
                r.add(ObjectUtils.copy(obj));
            }
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to copy set", e);
        }
    }

    public static Object mapCopy(Map map) {
        if (map == null) {
            return null;
        }
        try {
            Map r = (Map)map.getClass().newInstance();
            for (Object key : map.keySet()) {
                r.put(key, ObjectUtils.copy(map.get(key)));
            }
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to copy map", e);
        }
    }

    public static Object listCopy(List list) {
        if (list == null) {
            return null;
        }
        try {
            List r = (List)list.getClass().newInstance();
            for (Object obj : list) {
                r.add(ObjectUtils.copy(obj));
            }
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to copy list", e);
        }
    }

    public static Object cloneCopy(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (!ObjectUtils.isCloneable(obj)) {
            throw new IllegalArgumentException("parameter obj: " + obj + " is not cloneable");
        }
        try {
            Class<?> clazz = obj.getClass();
            Method method = MethodUtils.findPublicMethod(clazz, "clone", new Class[0]);
            method.setAccessible(true);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to clone copy", e);
        }
    }

    public static void copy(Object src, Object dst) {
        BeanCopier existing;
        if (src == null) {
            throw new IllegalArgumentException("invalid parameter src");
        }
        if (dst == null) {
            throw new IllegalArgumentException("invalid parameter dst");
        }
        if (!src.getClass().equals(dst.getClass())) {
            throw new IllegalArgumentException("the class does not match, src: " + src.getClass() + ", dst: " + dst.getClass());
        }
        Class<?> clazz = src.getClass();
        BeanCopier copier = BEAN_COPIERS.get(clazz);
        if (copier == null && (existing = BEAN_COPIERS.putIfAbsent(clazz, copier = BeanCopier.create(clazz, clazz, (boolean)false))) != null) {
            copier = existing;
        }
        copier.copy(src, dst, null);
    }

    public static boolean registerImmutableClass(Class<?> clazz) {
        return IMMUTABLE_CLASSES.add(clazz);
    }

    public static boolean unregisterImmutableClass(Class<?> clazz) {
        return IMMUTABLE_CLASSES.remove(clazz);
    }

    @Deprecated
    public static Object getMappingValue(Object data, String key) {
        if (data == null || StringUtils.isBlank((String)key)) {
            return null;
        }
        int index = key.indexOf(".");
        int arrayIndex = -1;
        String firstKey = index > -1 ? key.substring(0, index) : key;
        Pattern p = Pattern.compile("(\\w+)\\[([0-9]+)\\]$");
        Matcher m = p.matcher(firstKey);
        if (m.find()) {
            firstKey = m.group(1);
            arrayIndex = Integer.parseInt(m.group(2));
        }
        Object tmp = null;
        tmp = data instanceof Map ? ((Map)data).get(firstKey) : FieldUtils.getBeanProperty(data, firstKey);
        if (tmp != null && arrayIndex > -1) {
            if (tmp instanceof List) {
                List tmpList = (List)tmp;
                tmp = tmpList.get(arrayIndex);
            } else if (tmp.getClass().isArray()) {
                tmp = arrayIndex > ((Object[])tmp).length ? null : ((Object[])tmp)[arrayIndex];
            } else {
                throw new BaseException("class {0} is not array or list.", tmp.getClass());
            }
        }
        if (tmp != null && index > -1) {
            return ObjectUtils.getMappingValue(tmp, key.substring(index + 1, key.length()));
        }
        return tmp;
    }

    @Deprecated
    public static Class getMappingValueType(Class clazz, String key) {
        Assert.notNull((Object)clazz, "clazz can not be null.", new Object[0]);
        Assert.notBlank(key, "key can not be blank.", new Object[0]);
        if (Map.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        int index = key.indexOf(".");
        int arrayIndex = -1;
        String firstKey = index > -1 ? key.substring(0, index) : key;
        Pattern p = Pattern.compile("(\\w+)\\[([0-9]+)\\]$");
        Matcher m = p.matcher(firstKey);
        if (m.find()) {
            firstKey = m.group(1);
            arrayIndex = Integer.parseInt(m.group(2));
        }
        Class<?> valType = FieldUtils.getBeanPropertyType(clazz, firstKey);
        if (arrayIndex > -1) {
            if (List.class.isAssignableFrom(valType)) {
                valType = FieldUtils.getFieldGenericType(clazz, firstKey);
            } else if (valType.isArray()) {
                valType = valType.getComponentType();
            } else {
                throw new BaseException("class {0} is not array or list.", valType);
            }
        }
        if (index > -1) {
            return ObjectUtils.getMappingValueType(valType, key.substring(index + 1, key.length()));
        }
        return valType;
    }

    @Deprecated
    public static void setMappingValue(Object data, String key, Object value) {
        ObjectUtils.setMappingValue(data, key, value, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static void setMappingValue(Object data, String key, Object value, Map<String, Class<?>> assignClasses) {
        Class<?> clazz;
        if (data == null) {
            return;
        }
        int index = key.indexOf(".");
        int arrayIndex = -1;
        String firstKey = index > -1 ? key.substring(0, index) : key;
        Pattern p = Pattern.compile("(\\w+)\\[([0-9]+)\\]$");
        Matcher m = p.matcher(firstKey);
        if (m.find()) {
            firstKey = m.group(1);
            arrayIndex = Integer.parseInt(m.group(2));
        }
        Class<?> assignClass = null;
        if (assignClasses != null && assignClasses.size() > 0) {
            String complexKey = arrayIndex > -1 ? firstKey + "[]" : firstKey;
            assignClass = assignClasses.get(complexKey);
            if (assignClasses.size() > 0) {
                HashMap hashMap = new HashMap(assignClasses.size());
                for (String string : assignClasses.keySet()) {
                    if (!string.startsWith(complexKey)) continue;
                    hashMap.put(string.substring(index + 1), assignClasses.get(string));
                }
                assignClasses = hashMap;
            }
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            if (index > -1) {
                Object v = map.get(firstKey);
                if (arrayIndex > -1) {
                    void var11_14;
                    if (v == null) {
                        ArrayList arrayList = new ArrayList();
                        map.put(firstKey, arrayList);
                    }
                    if (var11_14 instanceof List) {
                        void var13_62;
                        List list = (List)var11_14;
                        Object e = list.get(arrayIndex);
                        if (e == null) {
                            void var13_61;
                            if (assignClass != null) {
                                Object obj = ClassUtils.newInstance(assignClass);
                            } else {
                                HashMap hashMap = new HashMap();
                            }
                            list.add(arrayIndex, var13_61);
                        }
                        ObjectUtils.setMappingValue(var13_62, key.substring(index + 1, key.length()), value, assignClasses);
                        return;
                    } else {
                        void var12_47;
                        void var11_16;
                        Object object;
                        if (!var11_14.getClass().isArray()) throw new BaseException("class {0} is not array or list.", var11_14.getClass());
                        if (arrayIndex > ((Object[])var11_14).length) {
                            Object[] objectArray = Arrays.copyOf((Object[])var11_14, arrayIndex);
                        }
                        if ((object = Array.get(var11_16, arrayIndex)) == null) {
                            void var12_46;
                            if (assignClass != null) {
                                Object obj = ClassUtils.newInstance(assignClass);
                            } else {
                                Class<?> clazz2 = var11_16.getClass().getComponentType();
                                HashMap hashMap = clazz2 == null ? new HashMap() : ClassUtils.newInstance(clazz2);
                            }
                            Array.set(var11_16, arrayIndex, var12_46);
                        }
                        ObjectUtils.setMappingValue(var12_47, key.substring(index + 1, key.length()), value, assignClasses);
                    }
                    return;
                } else {
                    void var11_20;
                    if (v == null) {
                        void var11_19;
                        if (assignClass != null) {
                            Object obj = ClassUtils.newInstance(assignClass);
                        } else {
                            HashMap hashMap = new HashMap();
                        }
                        map.put(firstKey, var11_19);
                    }
                    ObjectUtils.setMappingValue(var11_20, key.substring(index + 1, key.length()), value, assignClasses);
                }
                return;
            }
            if (value == null) {
                return;
            }
            if (arrayIndex > -1) {
                void var11_25;
                void var11_23;
                Object v = map.get(firstKey);
                if (v == null) {
                    ArrayList arrayList = new ArrayList();
                    map.put(firstKey, arrayList);
                }
                if (var11_23 instanceof List) {
                    ((List)var11_23).add(arrayIndex, value);
                    return;
                }
                if (!var11_23.getClass().isArray()) throw new BaseException("class {0} is not array or list.", var11_23.getClass());
                if (arrayIndex > ((Object[])var11_23).length) {
                    Object[] objectArray = Arrays.copyOf((Object[])var11_23, arrayIndex);
                }
                if (!ClassUtils.isAssignable(value.getClass(), var11_25.getClass().getComponentType(), (boolean)true)) {
                    try {
                        value = DataConvert.convertType(value.toString(), var11_25.getClass().getComponentType());
                    }
                    catch (BaseException baseException) {
                        // empty catch block
                    }
                }
                Array.set(var11_25, arrayIndex, value);
                return;
            }
            map.put(firstKey, value);
            return;
        }
        Object[] tmp = FieldUtils.getBeanProperty(data, firstKey);
        if (index > -1) {
            if (tmp == null) {
                if (assignClass != null && arrayIndex == -1) {
                    tmp = ClassUtils.newInstance(assignClass);
                } else {
                    Class<?> clazz3 = FieldUtils.getBeanPropertyType(data.getClass(), firstKey);
                    tmp = ClassUtils.newInstance(clazz3);
                }
                Assert.notNull((Object)tmp, "Class {0} can not instance", tmp.getClass());
                FieldUtils.setBeanProperty(data, firstKey, tmp);
            }
            if (arrayIndex > -1) {
                if (tmp instanceof List) {
                    void var12_53;
                    List list = (List)tmp;
                    Object e = list.get(arrayIndex);
                    if (e == null) {
                        void var12_52;
                        if (assignClass != null) {
                            Object obj = ClassUtils.newInstance(assignClass);
                        } else {
                            Class clazz4 = FieldUtils.getFieldGenericType(data.getClass(), firstKey);
                            HashMap hashMap = clazz4 == null ? new HashMap() : ClassUtils.newInstance(clazz4);
                        }
                        list.add(arrayIndex, var12_52);
                    }
                    ObjectUtils.setMappingValue(var12_53, key.substring(index + 1, key.length()), value, assignClasses);
                    return;
                } else {
                    void var11_33;
                    Object object;
                    if (!tmp.getClass().isArray()) throw new BaseException("class {0} is not array or list.", tmp.getClass());
                    if (arrayIndex > ((Object[])tmp).length) {
                        tmp = Arrays.copyOf((Object[])tmp, arrayIndex);
                    }
                    if ((object = Array.get(tmp, arrayIndex)) == null) {
                        void var11_32;
                        if (assignClass != null) {
                            Object obj = ClassUtils.newInstance(assignClass);
                        } else {
                            Class<?> clazz5 = tmp.getClass().getComponentType();
                            HashMap hashMap = clazz5 == null ? new HashMap() : ClassUtils.newInstance(clazz5);
                        }
                        Array.set(tmp, arrayIndex, var11_32);
                    }
                    ObjectUtils.setMappingValue(var11_33, key.substring(index + 1, key.length()), value, assignClasses);
                }
                return;
            } else {
                ObjectUtils.setMappingValue(tmp, key.substring(index + 1, key.length()), value, assignClasses);
            }
            return;
        }
        if (value == null) {
            return;
        }
        if (arrayIndex > -1) {
            if (tmp == null) {
                void var11_36;
                Class<?> clazz6 = FieldUtils.getBeanPropertyType(data.getClass(), firstKey);
                if (clazz6 == Object.class) {
                    Class<List> clazz7 = List.class;
                }
                tmp = ClassUtils.newInstance(var11_36);
                Assert.notNull((Object)tmp, "Class {0} can not instance", tmp.getClass());
                FieldUtils.setBeanProperty(data, firstKey, tmp);
            }
            if (tmp instanceof List) {
                Class clazz8 = FieldUtils.getFieldGenericType(data.getClass(), firstKey);
                if (!ClassUtils.isAssignable(value.getClass(), (Class)clazz8, (boolean)true)) {
                    try {
                        value = DataConvert.convertType(value.toString(), clazz8);
                    }
                    catch (BaseException baseException) {
                        // empty catch block
                    }
                }
                ((List)tmp).add(arrayIndex, value);
                return;
            }
            if (!tmp.getClass().isArray()) throw new BaseException("class {0} is not array or list.", tmp.getClass());
            if (!ClassUtils.isAssignable(value.getClass(), tmp.getClass().getComponentType(), (boolean)true)) {
                try {
                    value = DataConvert.convertType(value.toString(), tmp.getClass().getComponentType());
                }
                catch (BaseException baseException) {
                    // empty catch block
                }
            }
            if (arrayIndex > tmp.length) {
                tmp = Arrays.copyOf(tmp, arrayIndex);
            }
            Array.set(tmp, arrayIndex, value);
            return;
        }
        Class<?> clazz9 = clazz = tmp == null ? FieldUtils.getBeanPropertyType(data.getClass(), firstKey) : tmp.getClass();
        if (!ClassUtils.isAssignable(value.getClass(), clazz, (boolean)true)) {
            try {
                value = DataConvert.convertType(value.toString(), clazz);
            }
            catch (BaseException baseException) {
                // empty catch block
            }
        }
        FieldUtils.setBeanProperty(data, firstKey, value);
    }

    static {
        PRIMITIVES_AND_WRAPPERS.add(Boolean.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Boolean.class);
        PRIMITIVES_AND_WRAPPERS.add(Byte.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Byte.class);
        PRIMITIVES_AND_WRAPPERS.add(Character.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Character.class);
        PRIMITIVES_AND_WRAPPERS.add(Double.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Double.class);
        PRIMITIVES_AND_WRAPPERS.add(Float.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Float.class);
        PRIMITIVES_AND_WRAPPERS.add(Integer.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Integer.class);
        PRIMITIVES_AND_WRAPPERS.add(Long.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Long.class);
        PRIMITIVES_AND_WRAPPERS.add(Short.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Short.class);
        IMMUTABLE_CLASSES = new HashSet();
        IMMUTABLE_CLASSES.add(Boolean.class);
        IMMUTABLE_CLASSES.add(Byte.class);
        IMMUTABLE_CLASSES.add(Character.class);
        IMMUTABLE_CLASSES.add(Double.class);
        IMMUTABLE_CLASSES.add(Float.class);
        IMMUTABLE_CLASSES.add(Integer.class);
        IMMUTABLE_CLASSES.add(Long.class);
        IMMUTABLE_CLASSES.add(Short.class);
        IMMUTABLE_CLASSES.add(Class.class);
        IMMUTABLE_CLASSES.add(String.class);
        IMMUTABLE_CLASSES.add(BigDecimal.class);
        IMMUTABLE_CLASSES.add(BigInteger.class);
        IMMUTABLE_CLASSES.add(java.util.Date.class);
        IMMUTABLE_CLASSES.add(Date.class);
    }
}

