/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.lang.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class RegularUtils {
    public static String addFileInLastURI(String originalUri, String fileName) {
        if (StringUtils.isBlank((String)originalUri) || StringUtils.isBlank((String)fileName)) {
            return originalUri;
        }
        return originalUri.replaceFirst("^((https?://)?(/|\\\\)?([^/\\\\]+(/|\\\\))*?)([^/\\\\]+(/|\\\\)?)$", "$1" + fileName + "/$6");
    }

    public static String removeFileInURI(String originalUri, String fileName) {
        if (StringUtils.isBlank((String)originalUri) || StringUtils.isBlank((String)fileName)) {
            return originalUri;
        }
        return originalUri.replaceAll("(/|\\\\)" + fileName + "([/\\\\]|$)", "$2");
    }

    public static String fileNamePrefix(String fileName, String prefix) {
        return RegularUtils.modifyFileName(fileName, prefix, null);
    }

    public static String fileNamePostfix(String fileName, String postfix) {
        return RegularUtils.modifyFileName(fileName, null, postfix);
    }

    public static String modifyFileName(String fileName, String prefix, String postfix) {
        if (StringUtils.isBlank((String)fileName)) {
            throw new BaseException("FileName is blank, can't modifyFileName.", new Object[0]);
        }
        prefix = prefix == null ? "" : prefix;
        postfix = postfix == null ? "" : postfix;
        return fileName.replaceFirst("^((https?://)?(/|\\\\)?([^/\\\\]+(/|\\\\))*)([^/\\\\\\.]+)((\\.[^/\\\\\\.]+)?)$", "$1" + prefix + "$6" + postfix + "$7");
    }

    public static String modifyFileName(String path, String newFileName) {
        if (StringUtils.isBlank((String)path)) {
            throw new BaseException("path is blank, can't modifyFileName.", new Object[0]);
        }
        if (StringUtils.isBlank((String)newFileName)) {
            return path;
        }
        return path.replaceAll("^((https?://)?(/|\\\\)?([^/\\\\]+(/|\\\\))*)[^/\\\\\\.]+(\\.[^/\\\\\\.]+)?$", "$1" + newFileName);
    }

    public static String modifyFileType(String path, String fileType) {
        if (StringUtils.isBlank((String)path) || StringUtils.isBlank((String)fileType)) {
            return path;
        }
        path = FilenameUtils.normalize((String)path, (boolean)true);
        int dotIndex = path.lastIndexOf(".");
        int slashIndex = path.lastIndexOf("/");
        if (slashIndex > dotIndex) {
            if (slashIndex == path.length() - 1) {
                throw new IllegalArgumentException("arg is not legal file path");
            }
            return path + "." + fileType;
        }
        return path.substring(0, dotIndex + 1) + fileType;
    }

    public static boolean isParamUrl(String url) {
        int lastIndex;
        return StringUtils.isNotBlank((String)url) && (lastIndex = url.lastIndexOf("?")) != -1 && (url = url.substring(lastIndex + 1)).length() > 0;
    }

    public static boolean verifyFileType(String file, String ... passType) {
        boolean passed = false;
        String postfix = FilenameUtils.getExtension((String)file);
        if (postfix == null) {
            throw new BaseException("file is null.", new Object[0]);
        }
        postfix = postfix.toLowerCase();
        for (String type : passType) {
            if (!postfix.equals(type)) continue;
            passed = true;
            break;
        }
        return passed;
    }

    public static String getUrl2ndPath(String url) {
        Pattern p = Pattern.compile("^.*?(/|\\\\)([^/\\\\]+)(/|\\\\)[^/\\\\]+(/|\\\\)?$");
        Matcher m = p.matcher(url);
        if (m.matches()) {
            return m.replaceFirst("$2");
        }
        return null;
    }

    public static String addImgUrlRule(String imgUrl, String[] rules) {
        if (StringUtils.isBlank((String)imgUrl) || rules.length == 0) {
            return imgUrl;
        }
        String tmp = StringUtils.join((Object[])rules, (String)"_");
        return imgUrl.replaceFirst("^(.+?)(\\.[a-z]+)$", "$1_" + tmp + "$2");
    }

    public static String addImgUrlRule(String imgUrl, String rule) {
        if (StringUtils.isBlank((String)imgUrl) || StringUtils.isBlank((String)rule)) {
            return imgUrl;
        }
        return imgUrl.replaceFirst("^(.+?)(\\.[a-z]+)$", "$1_" + rule + "$2");
    }

    public static String removeImgUrlRule(String imgUrl, String ... rules) {
        if (StringUtils.isBlank((String)imgUrl) || rules.length == 0) {
            return imgUrl;
        }
        String regUrl = "((_" + StringUtils.join((Object[])rules, (String)")|(_") + "))";
        return imgUrl.replaceAll(regUrl, "");
    }

    public static String getImgUrlOriginal(String imgUrl) {
        if (StringUtils.isBlank((String)imgUrl)) {
            return imgUrl;
        }
        return imgUrl.replaceAll("_[0-9a-z]+", "");
    }

    public static String getQueryString(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("?");
        if (index > -1) {
            return url.substring(index + 1);
        }
        return "";
    }

    public static void main(String[] args) {
        String a = RegularUtils.getQueryString("a?");
        System.out.println(a);
        System.out.println(FilenameUtils.removeExtension((String)"c:/a/b/c.TXT"));
    }
}

