/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public abstract class SerializationUtils {
    public static Serializable copy(Serializable obj) {
        if (obj == null) {
            return obj;
        }
        return SerializationUtils.deserialize(SerializationUtils.serialize(obj));
    }

    public static byte[] serialize(Serializable s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(s);
            oos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to serialize s: " + s, e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }

    public static Serializable deserialize(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return SerializationUtils.deserialize(data, 0, data.length);
    }

    public static Serializable deserialize(byte[] data, int offset, int length) {
        Serializable serializable;
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(data, offset, length);
            ObjectInputStream ois = new ObjectInputStream(bis);
            serializable = (Serializable)ois.readObject();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("failed to deserialize", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        return serializable;
    }
}

