/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import com.easycodebox.common.validate.Assert;

public class StringToken {
    private String source;
    private int index = -1;
    public static final char NULL = '\u0000';

    public StringToken(String source) {
        this.source = source;
    }

    public boolean more() {
        return this.source != null && this.index < this.source.length() - 1;
    }

    public char next() {
        if (this.more()) {
            return this.source.charAt(++this.index);
        }
        return '\u0000';
    }

    protected void back() {
        if (this.index > 0) {
            --this.index;
        }
    }

    protected void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public static void main(String[] args) {
        StringFormatToken p = new StringFormatToken("{", "}", "a{0-{x{}}b{na}mec", true);
        String key = null;
        while ((key = p.nextKey()) != null) {
            System.out.println("key: " + key);
            if (key.equals("x")) {
                p.insertBack("xv");
                continue;
            }
            p.insertBack("i");
        }
        System.out.println(p.getAssemble());
    }

    public static class StringFormatToken
    extends StringToken {
        private StringBuilder assemble;
        private boolean isAssemble;
        private boolean nest;
        private String open;
        private String close;
        private int start = -1;
        private int nestStart = -1;

        public StringFormatToken(String source) {
            this(source, false);
        }

        public StringFormatToken(String source, boolean isAssemble) {
            this("{", "}", source, isAssemble);
        }

        public StringFormatToken(String open, String close, String source, boolean isAssemble) {
            super(source);
            Assert.notBlank(open);
            Assert.notBlank(close);
            this.open = open;
            this.close = close;
            this.isAssemble = isAssemble;
            if (this.isAssemble) {
                this.assemble = new StringBuilder(source.length() * 3 / 2);
            }
        }

        private boolean matchOpen(char c) {
            int curIndex = this.getIndex();
            int i = 0;
            while (i < this.open.length()) {
                if (c != this.open.charAt(i)) {
                    this.setIndex(curIndex);
                    return false;
                }
                if (++i >= this.open.length()) continue;
                c = this.next();
            }
            return true;
        }

        private boolean matchClose(char c) {
            int curIndex = this.getIndex();
            int i = 0;
            while (i < this.close.length()) {
                if (c != this.close.charAt(i)) {
                    this.setIndex(curIndex);
                    return false;
                }
                if (++i >= this.close.length()) continue;
                c = this.next();
            }
            return true;
        }

        private void initStatus() {
            this.nestStart = -1;
            this.start = -1;
            this.nest = false;
        }

        public String nextKey() {
            char c;
            this.initStatus();
            boolean hasOpen = false;
            boolean hasClose = false;
            StringBuilder key = null;
            StringBuilder nestKey = null;
            while ((c = this.next()) != '\u0000') {
                if (c == '\\') {
                    if (hasOpen) {
                        char n = this.next();
                        key.append(c).append(n);
                        if (!this.nest) continue;
                        nestKey.append(c).append(n);
                        continue;
                    }
                    if (!this.isAssemble) continue;
                    this.assemble.append(c).append(this.next());
                    continue;
                }
                if (this.matchOpen(c)) {
                    if (hasOpen) {
                        this.nest = true;
                        nestKey = new StringBuilder();
                        this.nestStart = this.getIndex() - this.open.length();
                        continue;
                    }
                    hasOpen = true;
                    key = new StringBuilder();
                    this.start = this.getIndex() - this.open.length();
                    continue;
                }
                if (this.matchClose(c)) {
                    if (hasOpen) {
                        hasClose = true;
                        break;
                    }
                    if (!this.isAssemble) continue;
                    this.assemble.append(c);
                    continue;
                }
                if (hasOpen) {
                    key.append(c);
                    if (!this.nest) continue;
                    nestKey.append(c);
                    continue;
                }
                if (!this.isAssemble) continue;
                this.assemble.append(c);
            }
            if (hasOpen && !hasClose) {
                if (this.isAssemble) {
                    this.assemble.append(this.open).append((CharSequence)key);
                }
                key = null;
                this.start = -1;
                if (this.nest) {
                    nestKey = null;
                    this.nestStart = -1;
                }
            }
            return nestKey == null ? (key == null ? null : key.toString()) : nestKey.toString();
        }

        public String getAssemble() {
            return this.assemble == null ? null : this.assemble.toString();
        }

        public boolean isNest() {
            return this.nest;
        }

        public void insertBack(String val) {
            if (this.nest) {
                this.setSource(this.getSource().substring(0, this.nestStart + 1) + val + this.getSource().substring(this.getIndex() + 1));
                this.setIndex(this.start);
            } else if (this.isAssemble) {
                this.assemble.append(val);
            }
        }

        public String getOpen() {
            return this.open;
        }

        public String getClose() {
            return this.close;
        }
    }

    public static class OgnlToken
    extends StringToken {
        private boolean dynamicKey = false;

        public OgnlToken(String source) {
            super(source);
        }

        public boolean isDynamicKey() {
            return this.dynamicKey;
        }

        public void resetDynamicKey() {
            this.dynamicKey = false;
        }

        public String nextKey() {
            char c;
            StringBuilder sb = new StringBuilder();
            this.dynamicKey = false;
            block10: while ((c = this.next()) != '\u0000') {
                switch (c) {
                    case '\\': {
                        sb.append(c).append(this.next());
                        continue block10;
                    }
                    case '.': {
                        break block10;
                    }
                    case '[': {
                        char inner;
                        if (sb.length() > 0) {
                            this.back();
                            break block10;
                        }
                        while ((inner = this.next()) != '\u0000') {
                            boolean isStrKey = false;
                            block5 : switch (inner) {
                                case ']': {
                                    continue block10;
                                }
                                case '\\': {
                                    sb.append(inner).append(this.next());
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    char inmost;
                                    while ((inmost = this.next()) != '\u0000') {
                                        if (inmost == inner) {
                                            isStrKey = true;
                                            break block5;
                                        }
                                        if (inmost == '\\') {
                                            sb.append(inmost).append(this.next());
                                            continue;
                                        }
                                        sb.append(inmost);
                                    }
                                    break;
                                }
                                default: {
                                    sb.append(inner);
                                }
                            }
                            this.dynamicKey = !isStrKey;
                        }
                        continue block10;
                    }
                    default: {
                        sb.append(c);
                        continue block10;
                    }
                }
            }
            return sb.toString().trim();
        }
    }
}

