/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.enums.EnumClassFactory;
import com.easycodebox.common.enums.entity.DataType;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.ObjectUtils;
import com.easycodebox.common.lang.StringToken;
import com.easycodebox.common.lang.reflect.ClassUtils;
import com.easycodebox.common.lang.reflect.FieldUtils;
import com.easycodebox.common.validate.Regex;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static final int EMPTY_INDEX_MODEL = 1;
    public static final int NUM_INDEX_MODEL = 2;
    public static final int KEY_VALUE_MODEL = 4;
    private static final String JSON_VALUE = "-JV";
    private static final String ENUM_VALUE = "-ENUM-";

    public static String string2unicode(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0010') {
                sb.append("\\u000" + Integer.toHexString(ch));
                continue;
            }
            if (ch < '\u0100') {
                sb.append("\\u00" + Integer.toHexString(ch));
                continue;
            }
            if (ch < '\u1000') {
                sb.append("\\u0" + Integer.toHexString(ch));
                continue;
            }
            sb.append("\\u" + Integer.toHexString(ch));
        }
        return sb.toString();
    }

    public static String unicode2string(String str) {
        if (str == null) {
            return null;
        }
        String[] strs = str.toLowerCase().split("\\\\u");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i].trim().equals("")) continue;
            char ch = (char)Integer.parseInt(strs[i].trim(), 16);
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String format(String str, Object ... args) {
        return StringUtils.formatMix(str, 7, "null", args);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatMix(String str, int model, String defaultVal, Object ... args) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        if (args == null) {
            args = new Object[]{};
        }
        StringToken.StringFormatToken token = new StringToken.StringFormatToken(str, true);
        String key = null;
        ArrayList<Object> maps = null;
        int index = -1;
        if ((model & 4) > 0) {
            void var10_12;
            Object[] objectArray = args;
            int n = objectArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                Class<?> clazz;
                Object arg = objectArray[var10_12];
                if (!(arg == null || (clazz = arg.getClass()).isPrimitive() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.isArray() || Collection.class.isAssignableFrom(clazz))) {
                    maps = new ArrayList<Object>(4);
                    maps.add(arg);
                }
                ++var10_12;
            }
        }
        while ((key = token.nextKey()) != null) {
            String val = null;
            if (maps != null && (model & 4) > 0 && StringUtils.isNotBlank((String)key)) {
                for (Object e : maps) {
                    if (Map.class.isAssignableFrom(e.getClass())) {
                        Object obj;
                        Map tmpMap = (Map)e;
                        if (!tmpMap.containsKey(key) || (val = (obj = tmpMap.get(key)) == null ? null : obj.toString()) == null) continue;
                        break;
                    }
                    try {
                        Object obj = PropertyUtils.getProperty(e, (String)key);
                        val = obj == null ? null : obj.toString();
                        if (val == null) continue;
                        break;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    }
                }
            }
            if (val == null && (model & 1) > 0 && StringUtils.isBlank((String)key)) {
                String string = args.length > ++index ? (args[index] == null ? null : args[index].toString()) : (val = null);
            }
            if (val == null && (model & 2) > 0 && Pattern.matches(Regex.NUM.getRegex(), key)) {
                int intKey = Integer.parseInt(key);
                String string = args.length > intKey ? (args[intKey] == null ? null : args[intKey].toString()) : (val = null);
            }
            token.insertBack(val == null ? (defaultVal == null ? token.getOpen() + key + token.getClose() : defaultVal) : val);
        }
        return token.getAssemble();
    }

    public static String formatExp2String(String paramsStr, Object data, DataType dataType, Map<String, List<Map<String, Object>>> enums) throws JsonGenerationException, JsonMappingException, IOException {
        if (StringUtils.isBlank((String)paramsStr) || data == null) {
            return paramsStr;
        }
        Pattern p = Pattern.compile("([\\w\\.\"-]+)(\\s*[=:]\\s*)((\\[\\s*([\\w\\.-]+)\\s*/\\s*\\])|(\\[\\s*([\\w\\.-]+)\\s*\\]([\\s\\S]*?)\\[\\s*/\\s*\\7\\s*\\])|(\\$\\{\\s*([\\w\\.-]+)\\s*\\}))");
        Matcher matcher = p.matcher(paramsStr);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                Object val;
                String key;
                boolean isJson;
                String keyName = matcher.group(1);
                String symbol = matcher.group(2);
                String enumClassName = null;
                boolean bl = isJson = dataType == DataType.JSON;
                if (StringUtils.isNotBlank((String)matcher.group(4))) {
                    key = matcher.group(5);
                    if (dataType == DataType.MIX) {
                        int jsonIndex = matcher.group(5).indexOf(JSON_VALUE);
                        key = jsonIndex > -1 ? key.substring(0, jsonIndex) : key;
                        isJson = true;
                    }
                    if (key.indexOf(ENUM_VALUE) > -1) {
                        String[] frags = key.split(ENUM_VALUE);
                        key = frags[0];
                        enumClassName = frags[1];
                    }
                    val = (val = StringUtils.getMappingValue(data, key, enumClassName, enums)) == null || val instanceof Collection || val.getClass().isArray() ? StringUtils.convertParam(keyName, symbol, val, isJson) : StringUtils.convertParam(keyName, symbol, new Object[]{val}, isJson);
                    matcher.appendReplacement(sb, val.toString());
                    continue;
                }
                if (StringUtils.isNotBlank((String)matcher.group(6)) && StringUtils.isBlank((String)matcher.group(8))) {
                    key = matcher.group(7);
                    if (dataType == DataType.MIX) {
                        int jsonIndex = matcher.group(7).indexOf(JSON_VALUE);
                        key = jsonIndex > -1 ? key.substring(0, jsonIndex) : key;
                        isJson = true;
                    }
                    if (key.indexOf(ENUM_VALUE) > -1) {
                        String[] frags = key.split(ENUM_VALUE);
                        key = frags[0];
                        enumClassName = frags[1];
                    }
                    val = (val = StringUtils.getMappingValue(data, key, enumClassName, enums)) == null || val instanceof Collection || val.getClass().isArray() ? StringUtils.convertParam(keyName, symbol, val, isJson) : StringUtils.convertParam(keyName, symbol, new Object[]{val}, isJson);
                    matcher.appendReplacement(sb, val.toString());
                    continue;
                }
                if (StringUtils.isNotBlank((String)matcher.group(6)) && StringUtils.isNotBlank((String)matcher.group(8))) {
                    key = matcher.group(7);
                    if (dataType == DataType.MIX) {
                        int jsonIndex = matcher.group(7).indexOf(JSON_VALUE);
                        key = jsonIndex > -1 ? key.substring(0, jsonIndex) : key;
                        isJson = true;
                    }
                    if (key.indexOf(ENUM_VALUE) > -1) {
                        String[] frags = key.split(ENUM_VALUE);
                        key = frags[0];
                        enumClassName = frags[1];
                    }
                    if ((val = StringUtils.getMappingValue(data, key, enumClassName, enums)) == null) {
                        val = StringUtils.convertParam(keyName, symbol, val, isJson);
                    } else {
                        Object[] objectArray;
                        if (val instanceof Collection) {
                            val = ((Collection)val).toArray();
                        }
                        if (val.getClass().isArray()) {
                            objectArray = val;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = val;
                        }
                        Object[] vals = objectArray;
                        String fmtStr = "";
                        if (vals.length > 0) {
                            for (int i = 0; i < vals.length; ++i) {
                                String sub = StringUtils.formatExp2String(matcher.group(8), vals[i], dataType, enums);
                                if (isJson) {
                                    fmtStr = i == 0 ? fmtStr + keyName + symbol + "[" + sub : fmtStr + "," + sub;
                                    if (i != vals.length - 1) continue;
                                    fmtStr = fmtStr + "]";
                                    continue;
                                }
                                fmtStr = fmtStr + keyName + "[]" + symbol + sub;
                                if (i >= vals.length - 1) continue;
                                fmtStr = fmtStr + "&";
                            }
                        } else {
                            fmtStr = isJson ? fmtStr + keyName + symbol + "[]" : fmtStr + keyName + "[]" + symbol;
                        }
                        val = fmtStr;
                    }
                    matcher.appendReplacement(sb, val.toString());
                    continue;
                }
                key = matcher.group(10);
                if (dataType == DataType.MIX) {
                    int jsonIndex = matcher.group(10).indexOf(JSON_VALUE);
                    key = jsonIndex > -1 ? key.substring(0, jsonIndex) : key;
                    isJson = true;
                }
                if (key.indexOf(ENUM_VALUE) > -1) {
                    String[] frags = key.split(ENUM_VALUE);
                    key = frags[0];
                    enumClassName = frags[1];
                }
                val = StringUtils.getMappingValue(data, key, enumClassName, enums);
                matcher.appendReplacement(sb, StringUtils.convertParam(keyName, symbol, val, isJson));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return paramsStr;
    }

    @Deprecated
    private static Object getMappingValue(Object data, String key, String enumClassName, Map<String, List<Map<String, Object>>> enums) {
        Object val = ObjectUtils.getMappingValue(data, key);
        if (enumClassName != null && val != null) {
            if (enums == null || !enums.containsKey(enumClassName)) {
                throw new BaseException("has no enum named {0} in enums", enumClassName);
            }
            String enumName = null;
            enumName = val instanceof Enum ? ((Enum)val).name() : val.toString();
            List<Map<String, Object>> enumObjs = enums.get(enumClassName);
            boolean exist = false;
            for (Map<String, Object> enumObj : enumObjs) {
                Object name = enumObj.get("name");
                if (!enumName.equals(name)) continue;
                val = enumObj.get("value");
                exist = true;
                break;
            }
            if (!exist) {
                throw new BaseException("has no enum named {0} in enums", enumName);
            }
        }
        return val;
    }

    private static String convertParam(String keyName, String symbol, Object data, boolean isJson) throws JsonGenerationException, JsonMappingException, IOException {
        String val = keyName + symbol;
        if (isJson) {
            val = val + Jacksons.COMMUNICATE.toJson(data);
        } else if (data != null) {
            if (data instanceof Date) {
                val = val + ((Date)data).getTime() + "";
            } else if (data instanceof DetailEnum) {
                val = val + ((DetailEnum)data).getValue().toString();
            } else if (data.getClass().isArray()) {
                Object[] array = (Object[])data;
                val = "";
                for (int i = 0; i < array.length; ++i) {
                    val = val + keyName + "[]" + symbol + array[i].toString();
                    if (i >= array.length - 1) continue;
                    val = val + "&";
                }
            } else if (data instanceof Collection) {
                val = "";
                for (Object obj : (Collection)data) {
                    val = val + keyName + "[]" + symbol + obj.toString() + "&";
                }
                if (val.length() > 1 && "&".equals("" + val.charAt(val.length() - 1))) {
                    val = val.substring(0, val.length() - 2);
                }
            } else {
                val = val + data.toString();
            }
        }
        return val;
    }

    public static String convertStr2Reg(String data) {
        if (data == null) {
            return null;
        }
        StringBuilder fragBuffer = new StringBuilder();
        block8: for (int i = 0; i < data.length(); ++i) {
            char f = data.charAt(i);
            switch (f) {
                case '!': 
                case '&': 
                case '*': 
                case '+': 
                case '.': 
                case ':': 
                case '=': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    fragBuffer.append("\\").append(f);
                    continue block8;
                }
                case '\b': {
                    fragBuffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    fragBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    fragBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    fragBuffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    fragBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    fragBuffer.append(f);
                }
            }
        }
        return fragBuffer.toString();
    }

    @Deprecated
    public static <T> T formatExp2Object(String fmtStr, String dataStr, Class<T> dataClass, Map<String, List<Map<String, Object>>> enums) throws JsonParseException, JsonMappingException, IOException {
        return StringUtils.formatExp2Object(fmtStr, dataStr, dataClass, null, enums);
    }

    @Deprecated
    public static <T> T formatExp2Object(String fmtStr, String dataStr, Class<T> dataClass, Map<String, Class<?>> assignClasses, Map<String, List<Map<String, Object>>> enums) throws JsonParseException, JsonMappingException, IOException {
        return StringUtils.formatExp2Object(fmtStr, dataStr, dataClass, assignClasses, "", enums);
    }

    @Deprecated
    public static <T> T formatExp2Object(String fmtStr, String dataStr, Class<T> dataClass, Map<String, Class<?>> assignClasses, String keyPrefix, Map<String, List<Map<String, Object>>> enums) throws JsonParseException, JsonMappingException, IOException {
        Map originalData = Jacksons.NON_NULL.toBean(dataStr, Map.class);
        T data = ClassUtils.newInstance(dataClass);
        if (StringUtils.isBlank((String)fmtStr) || StringUtils.isBlank((String)dataStr)) {
            return data;
        }
        Pattern p = Pattern.compile("([\\w\\.\"-]+)(\\s*[=:]\\s*)((\\[\\s*([\\w\\.-]+)\\s*/\\s*\\])|(\\[\\s*([\\w\\.-]+)\\s*\\]([\\s\\S]*?)\\[\\s*/\\s*\\7\\s*\\])|(\\$\\{\\s*([\\w\\.-]+)\\s*\\}))");
        Matcher matcher = p.matcher(fmtStr);
        boolean result = matcher.find();
        if (result) {
            do {
                String key = matcher.group(1);
                String wrapper = null;
                String array = null;
                String enumClassName = null;
                if (StringUtils.isNotBlank((String)matcher.group(4))) {
                    wrapper = matcher.group(5);
                } else if (StringUtils.isNotBlank((String)matcher.group(6)) && StringUtils.isBlank((String)matcher.group(8))) {
                    wrapper = matcher.group(7);
                } else if (StringUtils.isNotBlank((String)matcher.group(6)) && StringUtils.isNotBlank((String)matcher.group(8))) {
                    wrapper = matcher.group(7);
                    array = matcher.group(8);
                } else {
                    wrapper = matcher.group(10);
                }
                Enum<?> proVal = ObjectUtils.getMappingValue(originalData, StringUtils.unquote(key));
                if (wrapper.indexOf(ENUM_VALUE) > -1) {
                    String[] frags = wrapper.split(ENUM_VALUE);
                    wrapper = frags[0];
                    enumClassName = frags[1];
                }
                if (enumClassName != null) {
                    if (enums == null || !enums.containsKey(enumClassName)) {
                        throw new BaseException("has no enum named {0} in enums.", enumClassName);
                    }
                    List<Map<String, Object>> enumObjs = enums.get(enumClassName);
                    boolean exist = false;
                    for (Map<String, Object> enumObj : enumObjs) {
                        Object value = enumObj.get("value");
                        if (value != proVal && (value == null || !value.equals(proVal)) && (value == null || proVal == null || !value.toString().equals(proVal.toString()))) continue;
                        String name = enumObj.get("name").toString();
                        proVal = Enum.valueOf(EnumClassFactory.newInstance(enumClassName), name);
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        throw new BaseException("has no enum valued {0} in enums", proVal);
                    }
                }
                if (array != null) {
                    ArrayList listVal = null;
                    if (proVal instanceof List) {
                        listVal = (ArrayList)((Object)proVal);
                    } else {
                        listVal = new ArrayList();
                        listVal.add(proVal);
                    }
                    String newKey = keyPrefix.length() > 0 ? keyPrefix + "." + wrapper : wrapper;
                    Class<?> proClazz = assignClasses == null ? null : assignClasses.get(newKey + "[]");
                    proClazz = proClazz == null ? FieldUtils.getFieldGenericType(data.getClass(), wrapper) : proClazz;
                    for (int i = 0; i < listVal.size(); ++i) {
                        Object val = listVal.get(i);
                        if (val == null) continue;
                        Object subData = StringUtils.formatExp2Object(array, Jacksons.NON_NULL.toJson(val), proClazz == null ? val.getClass() : proClazz, assignClasses, wrapper, enums);
                        ObjectUtils.setMappingValue(data, wrapper + "[" + i + "]", subData, assignClasses);
                    }
                } else {
                    ObjectUtils.setMappingValue(data, wrapper, proVal, assignClasses);
                }
            } while (result = matcher.find());
        }
        return data;
    }

    public static String unquote(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block10: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append(c);
                    continue block10;
                }
                case '\"': {
                    sb.append('\\');
                    sb.append(c);
                    continue block10;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        return StringUtils.quote(value.toString());
    }

    public static String filterHtml(String str) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("<\\s*script[^>]*>(.*?<\\s*/\\s*script[^>]*>)?", 2);
        m = p.matcher(str);
        str = m.replaceAll("");
        p = Pattern.compile("<\\s*style[^>]*>(.*?<\\s*/\\s*style[^>]*>)?", 2);
        m = p.matcher(str);
        str = m.replaceAll("");
        p = Pattern.compile("<[^>]+>");
        m = p.matcher(str);
        str = m.replaceAll("");
        return str;
    }

    public static String filterUnsafeHtml(String str) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("<\\s*script[^>]*>(.*?<\\s*/\\s*script[^>]*>)?", 2);
        m = p.matcher(str);
        str = m.replaceAll("");
        p = Pattern.compile("<\\s*style[^>]*>(.*?<\\s*/\\s*style[^>]*>)?", 2);
        m = p.matcher(str);
        str = m.replaceAll("");
        p = Pattern.compile("<\\s*((frameset)|(frame)|(iframe))[^>]*>(.*?<\\s*/\\s*((frameset)|(frame)|(iframe))[^>]*>)?", 2);
        m = p.matcher(str);
        str = m.replaceAll("");
        return str;
    }

    public static List<String> split2List(String str, String separator) {
        return StringUtils.split2List(str, separator, true);
    }

    public static List<String> split2List(String str, String separator, boolean trim) {
        StringTokenizer strTokens = new StringTokenizer(str, separator);
        ArrayList<String> list = new ArrayList<String>();
        while (strTokens.hasMoreTokens()) {
            list.add(trim ? strTokens.nextToken().trim() : strTokens.nextToken());
        }
        return list;
    }

    public static boolean isJavaIdentifier(String str) {
        if (StringUtils.isBlank((String)str) || !Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

