/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class TextUtils {
    public static final String htmlEncode(String s) {
        return TextUtils.htmlEncode(s, true);
    }

    public static final String htmlEncode(String s, boolean encodeSpecialChars) {
        s = TextUtils.noNull(s);
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
                continue;
            }
            if (encodeSpecialChars && c < '\u00ff') {
                String hexChars = "0123456789ABCDEF";
                int a = c % 16;
                int b = (c - a) / 16;
                String hex = "" + hexChars.charAt(b) + hexChars.charAt(a);
                str.append("&#x" + hex + ";");
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static final String join(String glue, Iterator pieces) {
        StringBuilder s = new StringBuilder();
        while (pieces.hasNext()) {
            s.append(pieces.next().toString());
            if (!pieces.hasNext()) continue;
            s.append(glue);
        }
        return s.toString();
    }

    public static final String join(String glue, String[] pieces) {
        return TextUtils.join(glue, Arrays.asList(pieces).iterator());
    }

    public static final String join(String glue, Collection pieces) {
        return TextUtils.join(glue, pieces.iterator());
    }

    public static final String noNull(String string, String defaultString) {
        return TextUtils.stringSet(string) ? string : defaultString;
    }

    public static final String noNull(String string) {
        return TextUtils.noNull(string, "");
    }

    public static final boolean stringSet(String string) {
        return string != null && !"".equals(string);
    }

    public static final boolean verifyUrl(String url) {
        if (url == null) {
            return false;
        }
        if (url.startsWith("https://")) {
            url = "http://" + url.substring(8);
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String null2String(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String toUtf8String(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                System.out.println(ex);
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String encodingFileName(String fileName) {
        String returnFileName = "";
        try {
            returnFileName = URLEncoder.encode(fileName, "UTF-8");
            returnFileName = StringUtils.replace((String)returnFileName, (String)"+", (String)"%20");
            if (returnFileName.length() > 150) {
                returnFileName = new String(fileName.getBytes("GB2312"), "ISO8859-1");
                returnFileName = StringUtils.replace((String)returnFileName, (String)" ", (String)"%20");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return returnFileName;
    }
}

