/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang.dto;

import com.easycodebox.common.lang.dto.AbstractBo;
import java.util.ArrayList;
import java.util.List;

public class DataPage<T>
extends AbstractBo {
    private static final long serialVersionUID = -7359451361372585994L;
    private Integer pageNo;
    private Integer pageSize;
    private Integer partIndex;
    private Integer partSize;
    private long totalCount;
    private List<T> data;
    private Integer nextPage;
    private Integer prePage;

    public DataPage() {
        this(1, 20, 0L, new ArrayList());
    }

    public DataPage(Integer pageNo, Integer pageSize, long totalCount, List<T> data) {
        this(pageNo, pageSize, null, null, totalCount, data);
    }

    public DataPage(Integer pageNo, Integer pageSize, Integer partIndex, Integer partSize, long totalCount, List<T> data) {
        if (partIndex != null && partSize != null) {
            this.partIndex = partIndex;
            this.partSize = partSize;
        }
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.data = data;
        this.nextPage = this.hasNextPage() ? Integer.valueOf(this.pageNo + 1) : Integer.valueOf(this.getTotalPage());
        this.prePage = this.hasPreviousPage() ? Integer.valueOf(this.pageNo - 1) : Integer.valueOf(1);
    }

    public int getTotalPage() {
        if (this.pageSize == null) {
            return 1;
        }
        if (this.totalCount % (long)this.pageSize.intValue() == 0L) {
            return (int)(this.totalCount / (long)this.pageSize.intValue());
        }
        return (int)(this.totalCount / (long)this.pageSize.intValue() + 1L);
    }

    public boolean hasNextPage() {
        return this.pageNo != null && this.pageNo < this.getTotalPage();
    }

    public boolean hasPreviousPage() {
        return this.pageNo != null && this.pageNo > 1;
    }

    public int getStart() {
        if (this.pageNo == null || this.pageSize == null) {
            return 0;
        }
        if (this.partIndex != null && this.partSize != null) {
            return DataPage.getStartOfPage(this.pageNo, this.pageSize, this.partIndex, this.partSize);
        }
        return (this.pageNo - 1) * this.pageSize;
    }

    public static int getPageNo(int limitStart, int pageSize) {
        return limitStart / pageSize + 1;
    }

    public static int getStartOfPage(int pageNo, int pageSize, Integer partIndex, Integer partSize) {
        if (partIndex != null && partSize != null) {
            int fullStart = (pageNo - 1) * pageSize;
            return fullStart + (partIndex - 1) * partSize;
        }
        return (pageNo - 1) * pageSize;
    }

    public static int getStartOfPage(Integer pageNo, Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return 0;
        }
        return DataPage.getStartOfPage(pageNo, pageSize, null, null);
    }

    public static int getObtainSize(int pageNo, int pageSize, Integer partIndex, Integer partSize) {
        if (partIndex == null || partSize == null) {
            return pageSize;
        }
        int nextPageStart = DataPage.getStartOfPage(pageNo + 1, pageSize);
        int partStart = DataPage.getStartOfPage(pageNo, pageSize, partIndex, partSize);
        if (partStart + partSize <= nextPageStart) {
            return partSize;
        }
        return nextPageStart - partStart;
    }

    public Integer getNextPage() {
        return this.nextPage;
    }

    public Integer getPrePage() {
        return this.prePage;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPartIndex() {
        return this.partIndex;
    }

    public void setPartIndex(Integer partIndex) {
        this.partIndex = partIndex;
    }

    public Integer getPartSize() {
        return this.partSize;
    }

    public void setPartSize(Integer partSize) {
        this.partSize = partSize;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public static void main(String[] args) {
        System.out.println(DataPage.getStartOfPage(4, 20, 2, 5));
        System.out.println(DataPage.getPageNo(25, 20));
    }
}

