/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang.reflect;

import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassUtils.class);

    public static List<Class<?>> getAllTypes(Class<?> clazz) {
        ArrayList clazzes = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllClasses(clazz);
        clazzes.addAll(list);
        for (Class<?> c : list) {
            clazzes.addAll(ClassUtils.getInterfaces(c));
        }
        return clazzes;
    }

    public static boolean isVoid(Class<?> clazz) {
        return clazz == Void.TYPE || clazz == Void.class;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static ClassLoader overrideThreadContextClassLoader(ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    public static Class getInterfacesGenricType(Class clazz) {
        return ClassUtils.getInterfacesGenricType(clazz, 0, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            throw new RuntimeException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return ClassUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getInterfacesGenricType(Class clazz, int interfaceIndex, int genricTypeIndex) {
        Type[] inteTypes = clazz.getGenericInterfaces();
        if (interfaceIndex >= inteTypes.length || interfaceIndex < 0) {
            throw new RuntimeException("\u4f60\u8f93\u5165\u7684\u63a5\u53e3\u7d22\u5f15\u503c" + (interfaceIndex < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u5b9e\u73b0\u63a5\u53e3\u7684\u603b\u6570"));
        }
        Type genType = inteTypes[interfaceIndex];
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (genricTypeIndex >= params.length || genricTypeIndex < 0) {
            throw new RuntimeException("\u4f60\u8f93\u5165\u7684\u6cdb\u578b\u7d22\u5f15\u503c" + (genricTypeIndex < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
        }
        if (!(params[genricTypeIndex] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[genricTypeIndex];
    }

    public static List<Class<?>> getAllClasses(Class<?> clazz) {
        return ClassUtils.getAllClasses(clazz, false);
    }

    public static List<Class<?>> getAllClasses(Class<?> clazz, boolean ignoreObjectClass) {
        ArrayList clazzes = new ArrayList();
        clazzes.add(clazz);
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (ignoreObjectClass && superClass == Object.class) continue;
            clazzes.add(superClass);
        }
        return clazzes;
    }

    private static List<Class<?>> getInterfaces(Class<?> clazz) {
        ArrayList r = new ArrayList();
        LinkedList stack = new LinkedList();
        stack.addAll(Arrays.asList(clazz.getInterfaces()));
        while (!stack.isEmpty()) {
            Class intf = (Class)stack.removeFirst();
            if (r.contains(intf)) continue;
            r.add(intf);
            stack.addAll(Arrays.asList(intf.getInterfaces()));
        }
        return r;
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (!clazz.isInterface()) {
            try {
                Constructor<T> c = clazz.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.debug((Object)"There is no empty param Constructor in class({0})", clazz);
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return (T)new HashMap();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return (T)new ArrayList();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return (T)new HashSet();
        }
        if (clazz.getClass().isArray()) {
            return (T)Array.newInstance(clazz.getComponentType(), 0);
        }
        return null;
    }

    public static String assembleProperty2Sql(Class<?> clazz, String alias) {
        List<Class<?>> clazzes = ClassUtils.getAllClasses(clazz, true);
        StringBuilder sb = new StringBuilder();
        for (Class<?> c : clazzes) {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                int m = f.getModifiers();
                if (Modifier.isFinal(m) || Modifier.isStatic(m)) continue;
                sb.append(alias).append(".").append(f.getName()).append(",").append(" ");
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getLastPkg(String pkg) {
        if (StringUtils.isBlank((String)pkg)) {
            return null;
        }
        int index = pkg.lastIndexOf(".");
        return pkg.substring(index + 1);
    }

    public static String getLastPkg(Class<?> clazz) {
        return ClassUtils.getLastPkg(ClassUtils.getPackageName(clazz));
    }

    public static void main(String[] args) throws NoSuchMethodException, SecurityException {
        System.out.println(ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true));
        class A {
            private A(int a) {
            }
        }
        System.out.println(A.class.getDeclaredConstructor(new Class[0]));
    }
}

