/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang.reflect;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.lang.reflect.MethodUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class FieldUtils
extends org.apache.commons.lang.reflect.FieldUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FieldUtils.class);

    public static List<Field> getAllFields(Class<?> clazz) {
        return FieldUtils.getAllFields(clazz, null, true);
    }

    public static List<Field> getAllFields(Class<?> clazz, boolean excludeStaticFileds) {
        return FieldUtils.getAllFields(clazz, null, excludeStaticFileds);
    }

    public static List<Field> getAllFields(Class<?> clazz, Class<? extends Annotation> annotation, boolean excludeStaticFileds) {
        if (clazz == null) {
            return null;
        }
        ArrayList<Field> r = new ArrayList<Field>();
        for (Class<?> parent = clazz; parent != null; parent = parent.getSuperclass()) {
            for (Field f : parent.getDeclaredFields()) {
                if (excludeStaticFileds && (f.getModifiers() & 8) != 0 || annotation != null && !f.isAnnotationPresent(annotation)) continue;
                if (!Modifier.isPublic(f.getModifiers())) {
                    f.setAccessible(true);
                }
                r.add(f);
            }
        }
        return r;
    }

    public static String getFieldName(Method m) {
        if (m == null) {
            return null;
        }
        if (!MethodUtils.isGetterMethod(m) && !MethodUtils.isSetterMethod(m)) {
            return null;
        }
        StringBuilder r = new StringBuilder();
        if (MethodUtils.isIsMethod(m)) {
            r.append(m.getName().substring(2));
        } else if (MethodUtils.isGetterMethod(m)) {
            r.append(m.getName().substring(3));
        } else if (MethodUtils.isSetterMethod(m)) {
            r.append(m.getName().substring(3));
        }
        r.replace(0, 1, r.substring(0, 1).toLowerCase());
        return r.toString();
    }

    public static Object getField(Object target, String name) throws Exception {
        Field f = target.getClass().getDeclaredField(name);
        if (!Modifier.isPublic(f.getModifiers())) {
            f.setAccessible(true);
        }
        return f.get(target);
    }

    public static Class getFieldGenericType(Field field, int index) {
        Type genericFieldType = field.getGenericType();
        if (genericFieldType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            if (index >= fieldArgTypes.length || index < 0) {
                throw new RuntimeException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
            }
            return (Class)fieldArgTypes[index];
        }
        return Object.class;
    }

    public static Class getFieldGenericType(Class clazz, String fieldName) {
        return FieldUtils.getFieldGenericType(clazz, fieldName, 0);
    }

    public static Class getFieldGenericType(Class clazz, String fieldName, int index) {
        if (clazz == null && StringUtils.isBlank((String)fieldName)) {
            return null;
        }
        Field field = FieldUtils.getField((Class)clazz, (String)fieldName, (boolean)true);
        if (field == null) {
            return null;
        }
        return FieldUtils.getFieldGenericType(field, index);
    }

    public static Class getFieldGenericType(Field field) {
        return FieldUtils.getFieldGenericType(field, 0);
    }

    @Deprecated
    public static Class<?> getBeanPropertyType(Class<?> clazz, String name) {
        Assert.notNull(clazz);
        Assert.notBlank(name);
        Method method = null;
        String methodName = "get" + StringUtils.capitalize((String)name);
        boolean accessField = false;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.debug((Object)(clazz.getName() + " has no {0} method."), methodName);
        }
        catch (SecurityException e) {
            LOG.debug((Object)" SecurityException.", e);
        }
        if (method == null) {
            methodName = "is" + StringUtils.capitalize((String)name);
            try {
                method = clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOG.debug((Object)(clazz.getName() + " has no {0} method."), methodName);
            }
            catch (SecurityException e) {
                LOG.debug((Object)" SecurityException.", e);
            }
        }
        if (method != null) {
            try {
                return method.getReturnType();
            }
            catch (Exception e) {
                LOG.debug((Object)" execute {0} method in class {1}.", methodName, clazz.getName());
                accessField = true;
            }
        } else {
            accessField = true;
        }
        if (accessField) {
            try {
                Field field = clazz.getDeclaredField(name);
                return field.getType();
            }
            catch (Exception e1) {
                throw new BaseException("call mehtod setBeanField error.", (Throwable)e1, new Object[0]);
            }
        }
        throw new BaseException("There is no property named {0}.", name);
    }

    @Deprecated
    public static Object getBeanProperty(Object target, String name) {
        if (target == null || StringUtils.isBlank((String)name)) {
            throw new BaseException("call getBeanProperty method error. params error.", new Object[0]);
        }
        Class<?> clazz = target.getClass();
        Method method = null;
        String methodName = "get" + StringUtils.capitalize((String)name);
        boolean accessField = false;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.debug((Object)(clazz.getName() + " has no {0} method."), methodName);
        }
        catch (SecurityException e) {
            LOG.debug((Object)" SecurityException.", e);
        }
        if (method == null) {
            methodName = "is" + StringUtils.capitalize((String)name);
            try {
                method = clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOG.debug((Object)(clazz.getName() + " has no {0} method."), methodName);
            }
            catch (SecurityException e) {
                LOG.debug((Object)" SecurityException.", e);
            }
        }
        if (method != null) {
            try {
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                LOG.debug((Object)" execute {0} method in class {1}.", methodName, clazz.getName());
                accessField = true;
            }
        } else {
            accessField = true;
        }
        if (accessField) {
            try {
                Field field = clazz.getDeclaredField(name);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                return field.get(target);
            }
            catch (Exception e1) {
                throw new BaseException("call mehtod getBeanProperty error.", (Throwable)e1, new Object[0]);
            }
        }
        throw new BaseException("call mehtod getBeanProperty error.", new Object[0]);
    }

    @Deprecated
    public static void setBeanProperty(Object target, String name, Object value) {
        Class<?> type = FieldUtils.getBeanPropertyType(target.getClass(), name);
        FieldUtils.setBeanProperty(target, name, type, value);
    }

    @Deprecated
    public static void setBeanProperty(Object target, String name, Class<?> type, Object value) {
        if (target == null || StringUtils.isBlank((String)name)) {
            throw new BaseException("call setBeanField method error. params error.", new Object[0]);
        }
        Class<?> clazz = target.getClass();
        String setMethod = "set" + StringUtils.capitalize((String)name);
        try {
            Method method = clazz.getMethod(setMethod, type);
            method.invoke(target, value);
        }
        catch (Exception e) {
            LOG.debug((Object)(clazz.getName() + " execute " + setMethod + " error."), e);
            try {
                Field field = clazz.getDeclaredField(name);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(target, value);
            }
            catch (Exception e1) {
                throw new BaseException("call mehtod setBeanField error.", (Throwable)e1, new Object[0]);
            }
        }
    }
}

