/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.lang.reflect;

import com.easycodebox.common.lang.reflect.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class MethodUtils
extends org.apache.commons.lang.reflect.MethodUtils {
    public static boolean hasMethod(Class<?> clazz, String method, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod(method, parameterTypes);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isIsMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("is")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType().equals(Boolean.TYPE);
    }

    public static boolean isGetterMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (MethodUtils.isIsMethod(method)) {
            return true;
        }
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !ClassUtils.isVoid(method.getReturnType());
    }

    public static boolean isSetterMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return ClassUtils.isVoid(method.getReturnType());
    }

    public static Method findGetterMethod(Class<?> clazz, Field field) {
        StringBuilder sb = new StringBuilder(field.getName());
        sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
        sb.insert(0, "get");
        Method r = MethodUtils.findPublicMethod(clazz, sb.toString(), new Class[0]);
        if (r == null) {
            if (field.getType().equals(Boolean.TYPE)) {
                sb.replace(0, 3, "is");
            }
            r = MethodUtils.findPublicMethod(clazz, sb.toString(), new Class[0]);
        }
        return r;
    }

    public static Method findGetterMethod(Class<?> clazz, String fieldName) {
        StringBuilder sb = new StringBuilder(fieldName);
        sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
        sb.insert(0, "get");
        Method r = MethodUtils.findPublicMethod(clazz, sb.toString(), new Class[0]);
        if (r == null) {
            try {
                Field field = clazz.getField(fieldName);
                if (field.getType().equals(Boolean.TYPE)) {
                    sb.replace(0, 3, "is");
                }
                r = MethodUtils.findPublicMethod(clazz, sb.toString(), new Class[0]);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return r;
    }

    public static Method findSetterMethod(Class<?> clazz, Field field) {
        StringBuilder sb = new StringBuilder(field.getName());
        sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
        sb.insert(0, "set");
        Class type = field.getType();
        if (type.isPrimitive()) {
            type = ClassUtils.primitiveToWrapper(type);
        }
        return MethodUtils.findPublicMethod(clazz, sb.toString(), new Class[]{type});
    }

    public static Method getPublicMethod(Class<?> clazz, String name, Class<?>[] signatures) throws NoSuchMethodException {
        Method r = MethodUtils.findPublicMethod(clazz, name, signatures);
        if (r == null) {
            throw new NoSuchMethodException(clazz.getName() + "." + name + ArrayUtils.toString(signatures));
        }
        return r;
    }

    public static Method findPublicMethod(Class<?> clazz, String name, Class<?>[] signatures) {
        if (signatures.length == 0) {
            try {
                return clazz.getMethod(name, signatures);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || !MethodUtils.matchArguments(signatures, method.getParameterTypes(), false)) continue;
            methods.add(method);
        }
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        for (Method method : methods) {
            if (!MethodUtils.matchArguments(signatures, method.getParameterTypes(), true)) continue;
            return method;
        }
        return MethodUtils.getMostSpecificMethod(methods, signatures);
    }

    private static Method getMostSpecificMethod(List<Method> methods, Class<?>[] signatures) {
        int maxMatches = 0;
        Method method = null;
        for (Method m : methods) {
            int matches = 0;
            Class<?>[] paramTypes = m.getParameterTypes();
            for (int i = 0; i < signatures.length; ++i) {
                Class paramType = paramTypes[i];
                if (paramType.isPrimitive() && !signatures[i].isPrimitive()) {
                    paramType = ClassUtils.primitiveToWrapper(paramType);
                }
                if (signatures[i] != paramType) continue;
                ++matches;
            }
            if (matches == 0 && maxMatches == 0) {
                if (method == null) {
                    method = m;
                    continue;
                }
                if (MethodUtils.matchArguments(method.getParameterTypes(), m.getParameterTypes(), false)) continue;
                method = m;
                continue;
            }
            if (matches > maxMatches) {
                maxMatches = matches;
                method = m;
                continue;
            }
            if (matches != maxMatches) continue;
            method = null;
        }
        return method;
    }

    private static boolean matchArguments(Class<?>[] signatures, Class<?>[] paramTypes, boolean explicit) {
        if (signatures.length != paramTypes.length) {
            return false;
        }
        for (int j = 0; j < signatures.length; ++j) {
            Class paramType = paramTypes[j];
            if (paramType.isPrimitive() && !signatures[j].isPrimitive()) {
                paramType = ClassUtils.primitiveToWrapper(paramType);
            }
            if (!(explicit ? signatures[j] != paramType : signatures[j] != null && !paramType.isAssignableFrom(signatures[j]))) continue;
            return false;
        }
        return true;
    }

    public static Class getMethodGenericReturnType(Method method, int index) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            Type[] typeArguments = type.getActualTypeArguments();
            if (index >= typeArguments.length || index < 0) {
                throw new RuntimeException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
            }
            return (Class)typeArguments[index];
        }
        return Object.class;
    }

    public static Class getMethodGenericReturnType(Method method) {
        return MethodUtils.getMethodGenericReturnType(method, 0);
    }

    public static List<Class> getMethodGenericParameterTypes(Method method, int index) {
        ArrayList<Class> results = new ArrayList<Class>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (index >= genericParameterTypes.length || index < 0) {
            throw new RuntimeException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
        }
        Type genericParameterType = genericParameterTypes[index];
        if (genericParameterType instanceof ParameterizedType) {
            Type[] parameterArgTypes;
            ParameterizedType aType = (ParameterizedType)genericParameterType;
            for (Type parameterArgType : parameterArgTypes = aType.getActualTypeArguments()) {
                Class parameterArgClass = (Class)parameterArgType;
                results.add(parameterArgClass);
            }
            return results;
        }
        return results;
    }

    public static List<Class> getMethodGenericParameterTypes(Method method) {
        return MethodUtils.getMethodGenericParameterTypes(method, 0);
    }
}

