/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.log;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class LogConfigListener
implements ServletContextListener {
    private static final String WEB_APP_ROOT_KEY = "webAppRootKey";
    private static final String DEFAULT_WEB_APP_ROOT_KEY = "webapp.root";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        String key = sc.getInitParameter(WEB_APP_ROOT_KEY);
        String root = sc.getRealPath("/");
        String oldValue = System.getProperty(key = key == null ? DEFAULT_WEB_APP_ROOT_KEY : key);
        if (oldValue != null && !oldValue.equals(root)) {
            throw new IllegalStateException("Web app root system property already set to different value: '" + key + "' = [" + oldValue + "] instead of [" + root + "] - Choose unique values for the 'webAppRootKey' context-param in your web.xml files!");
        }
        System.setProperty(key, root);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        String key = sce.getServletContext().getInitParameter(WEB_APP_ROOT_KEY);
        key = key == null ? DEFAULT_WEB_APP_ROOT_KEY : key;
        System.getProperties().remove(key);
    }
}

