/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluatorBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.math.NumberUtils;

public class CounterBasedEvaluator
extends EventEvaluatorBase<ILoggingEvent> {
    static int DEFAULT_LIMIT = 1024;
    private AtomicInteger counter = new AtomicInteger(NumberUtils.INTEGER_ZERO);
    private int limit = DEFAULT_LIMIT;
    private Level level = Level.ERROR;

    public boolean evaluate(ILoggingEvent event) throws NullPointerException, EvaluationException {
        if (event.getLevel().levelInt >= this.level.levelInt && this.counter.incrementAndGet() == this.limit) {
            this.counter.set(NumberUtils.INTEGER_ZERO);
            return true;
        }
        return false;
    }

    public int getCounter() {
        return this.counter.get();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

