/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluatorBase;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.math.NumberUtils;

public class TimeIntervalEvaluator
extends EventEvaluatorBase<ILoggingEvent> {
    static int DEFAULT_INTERVAL = 60;
    private AtomicBoolean using = new AtomicBoolean();
    private long last = NumberUtils.INTEGER_ZERO.intValue();
    private int interval = DEFAULT_INTERVAL;
    private Level level = Level.ERROR;

    public boolean evaluate(ILoggingEvent event) throws NullPointerException, EvaluationException {
        long current = System.currentTimeMillis() / 1000L;
        if (event.getLevel().levelInt >= this.level.levelInt && current - this.last > (long)this.interval && this.using.compareAndSet(false, true)) {
            this.last = current;
            this.using.set(false);
            return true;
        }
        return false;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

