/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.log.slf4j;

import com.easycodebox.common.lang.StringUtils;
import org.slf4j.Marker;

public final class Logger {
    private org.slf4j.Logger logger;

    public Logger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    private String str(Object msg) {
        return msg == null ? "null" : msg.toString();
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(Object msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.str(msg));
        }
    }

    public void trace(Object msg, Object ... args) {
        if (this.isTraceEnabled()) {
            this.logger.trace(StringUtils.format(this.str(msg), args));
        }
    }

    public void trace(Object msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger.trace(this.str(msg), t);
        }
    }

    public void trace(Object msg, Throwable t, Object ... args) {
        if (this.isTraceEnabled()) {
            this.logger.trace(StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, Object msg) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.str(msg));
        }
    }

    public void trace(Marker marker, Object msg, Object ... args) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, StringUtils.format(this.str(msg), args));
        }
    }

    public void trace(Marker marker, Object msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.str(msg), t);
        }
    }

    public void trace(Marker marker, Object msg, Throwable t, Object ... args) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(Object msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.str(msg));
        }
    }

    public void debug(Object msg, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.debug(StringUtils.format(this.str(msg), args));
        }
    }

    public void debug(Object msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.str(msg), t);
        }
    }

    public void debug(Object msg, Throwable t, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.debug(StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, Object msg) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.str(msg));
        }
    }

    public void debug(Marker marker, Object msg, Object ... args) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, StringUtils.format(this.str(msg), args));
        }
    }

    public void debug(Marker marker, Object msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.str(msg), t);
        }
    }

    public void debug(Marker marker, Object msg, Throwable t, Object ... args) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(Object msg) {
        this.logger.info(this.str(msg));
    }

    public void info(Object msg, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logger.info(StringUtils.format(this.str(msg), args));
        }
    }

    public void info(Object msg, Throwable t) {
        this.logger.info(this.str(msg), t);
    }

    public void info(Object msg, Throwable t, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logger.info(StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, Object msg) {
        this.logger.info(marker, this.str(msg));
    }

    public void info(Marker marker, Object msg, Object ... args) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, StringUtils.format(this.str(msg), args));
        }
    }

    public void info(Marker marker, Object msg, Throwable t) {
        this.logger.info(marker, this.str(msg), t);
    }

    public void info(Marker marker, Object msg, Throwable t, Object ... args) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(Object msg) {
        this.logger.warn(this.str(msg));
    }

    public void warn(Object msg, Object ... args) {
        if (this.isWarnEnabled()) {
            this.logger.warn(StringUtils.format(this.str(msg), args));
        }
    }

    public void warn(Object msg, Throwable t) {
        this.logger.warn(this.str(msg), t);
    }

    public void warn(Object msg, Throwable t, Object ... args) {
        if (this.isWarnEnabled()) {
            this.logger.warn(StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, Object msg) {
        this.logger.warn(marker, this.str(msg));
    }

    public void warn(Marker marker, Object msg, Object ... args) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, StringUtils.format(this.str(msg), args));
        }
    }

    public void warn(Marker marker, Object msg, Throwable t) {
        this.logger.warn(marker, this.str(msg), t);
    }

    public void warn(Marker marker, Object msg, Throwable t, Object ... args) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(Object msg) {
        this.logger.error(this.str(msg));
    }

    public void error(Object msg, Object ... args) {
        if (this.isErrorEnabled()) {
            this.logger.error(StringUtils.format(this.str(msg), args));
        }
    }

    public void error(Object msg, Throwable t) {
        this.logger.error(this.str(msg), t);
    }

    public void error(Object msg, Throwable t, Object ... args) {
        if (this.isErrorEnabled()) {
            this.logger.error(StringUtils.format(this.str(msg), args), t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, Object msg) {
        this.logger.error(marker, this.str(msg));
    }

    public void error(Marker marker, Object msg, Object ... args) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, StringUtils.format(this.str(msg), args));
        }
    }

    public void error(Marker marker, Object msg, Throwable t) {
        this.logger.error(marker, this.str(msg), t);
    }

    public void error(Marker marker, Object msg, Throwable t, Object ... args) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, StringUtils.format(this.str(msg), args), t);
        }
    }
}

