/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.mail;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.mail.Auth;
import com.easycodebox.common.mail.MailInfo;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MailUtils.class);

    public static MailInfo defaultMailInfo() {
        MailInfo info = new MailInfo();
        info.setMailServerHost(BaseConstants.mailHost);
        info.setMailServerPort("25");
        info.setValidate(true);
        info.setUsername(BaseConstants.mailUsername);
        info.setPassword(BaseConstants.mailPassword);
        info.setFromAddress(BaseConstants.mailFrom);
        return info;
    }

    public static void asynSendText(final String fromName, final String addressee, final String subject, final String content) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MailUtils.sendText(fromName, addressee, subject, content);
            }
        }).start();
    }

    public static boolean sendText(String fromName, String addressee, String subject, String content) {
        MailInfo mailInfo = MailUtils.defaultMailInfo();
        mailInfo.setToAddress(addressee);
        mailInfo.setSubject(subject);
        mailInfo.setContent(content);
        Auth authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new Auth(mailInfo.getUsername(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            String nick = MimeUtility.encodeText((String)fromName);
            mailMessage.setFrom((Address)new InternetAddress(nick + " <" + from + ">"));
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            mailMessage.setText(mailContent);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"send mail error!", e);
            return false;
        }
    }

    public static void asynSendHtml(final String fromName, final String addressee, final String subject, final String content) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MailUtils.sendHtml(fromName, addressee, subject, content);
            }
        }).start();
    }

    public static boolean sendHtml(String fromName, String addressee, String subject, String content) {
        MailInfo mailInfo = MailUtils.defaultMailInfo();
        mailInfo.setToAddress(addressee);
        mailInfo.setSubject(subject);
        mailInfo.setContent(content);
        Auth authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new Auth(mailInfo.getUsername(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            String nick = MimeUtility.encodeText((String)fromName);
            mailMessage.setFrom((Address)new InternetAddress(nick + " <" + from + ">"));
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)html);
            mailMessage.setContent((Multipart)mainPart);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"send mail error!", e);
            return false;
        }
    }

    public static void main(String[] args) throws AddressException {
        System.out.println("xx <" + new InternetAddress("rdj2eelogdev@easycodebox.com") + ">");
        String content = "test";
        MailUtils.asynSendHtml("VV", "381954728@qq.com", "\u8ba2\u5355\u63d0\u9192", content);
    }
}

