/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.net;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.file.UploadFileInfo;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.web.util.WebUtils;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getRequestUrlAndParams(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder("REQUEST URL === ");
        sb.append(request.getRequestURL()).append("?");
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = request.getParameterValues(key);
            sb.append(key).append("=").append(values == null || values.length > 1 ? DataConvert.array2String(values, ",", "[", "]", false, new String[0]) : values[0]).append("&");
        }
        return sb.toString();
    }

    public static Map<String, String> convertQueryParams2Map(String query) {
        String[] keyVals;
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isBlank((String)query)) {
            return params;
        }
        int index = query.indexOf("?");
        query = index > -1 ? query.substring(0, index) : query;
        for (String keyVal : keyVals = query.split("&")) {
            String[] kv = keyVal.split("=");
            params.put(kv[0], kv.length > 1 ? kv[1] : "");
        }
        return params;
    }

    public static String getFullRequestUri(HttpServletRequest request, boolean encode, String ... excludeKeys) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getRequestURI()).append("?");
        sb.append(HttpUtils.getRequestParams(request, encode, excludeKeys));
        String tmp = sb.toString();
        if (tmp.lastIndexOf("?") == tmp.length() - 1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    public static String getFullRequestUrl(HttpServletRequest request, boolean encode, String ... excludeKeys) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getRequestURL()).append("?");
        sb.append(HttpUtils.getRequestParams(request, encode, excludeKeys));
        String tmp = sb.toString();
        if (tmp.lastIndexOf("?") == tmp.length() - 1) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    public static String getParticularPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (StringUtils.isBlank((String)uri)) {
            return "";
        }
        if ("".equals(contextPath)) {
            return uri;
        }
        return uri.replaceFirst(contextPath, "");
    }

    public static String getShortPath(HttpServletRequest request) {
        String path = HttpUtils.getParticularPath(request);
        int index = path.lastIndexOf(".");
        return index == -1 ? path : path.substring(0, index);
    }

    public static String getBasePath(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (StringUtils.isNotEmpty((String)uri)) {
            int index = url.lastIndexOf(uri);
            url = url.substring(0, index);
        }
        if (!"".equals(contextPath)) {
            url = url + contextPath;
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static String[] getParticularPaths(HttpServletRequest request) {
        String path = HttpUtils.getParticularPath(request);
        path = path.charAt(0) == '/' ? path.substring(1) : path;
        String[] paths = path.split("/");
        int index = (path = paths[paths.length - 1]).lastIndexOf(".");
        if (index > -1) {
            paths[paths.length - 1] = path.substring(0, index);
        }
        return paths;
    }

    public static String getRequestParams(HttpServletRequest request, boolean encode, String ... excludeKeys) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Enumeration keys = request.getParameterNames();
        block0: while (keys.hasMoreElements()) {
            String[] values;
            String key = (String)keys.nextElement();
            if (excludeKeys != null && excludeKeys.length > 0) {
                for (String excludeKey : excludeKeys) {
                    if (excludeKey != null && excludeKey.equals(key)) continue block0;
                }
            }
            if ((values = request.getParameterValues(key)) == null) continue;
            for (int i = 0; i < values.length; ++i) {
                sb.append(key).append(values.length > 1 && BaseConstants.httpParamTradition == false ? "[]" : "").append("=").append(encode ? URLEncoder.encode(URLEncoder.encode(values[i], "UTF-8"), "UTF-8") : values[i]).append("&");
            }
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '&') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String assembleParams(Map<?, ?> params, Collection<?> jsonKeys, String ... excludeKeys) throws JsonGenerationException, JsonMappingException, IOException {
        StringBuilder sb = new StringBuilder();
        if (params != null && params.size() > 0) {
            block0: for (Map.Entry<?, ?> entry : params.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                String key = entry.getKey().toString();
                if (excludeKeys != null && excludeKeys.length > 0) {
                    for (String string : excludeKeys) {
                        if (string != null && string.equals(key)) continue block0;
                    }
                }
                Object value = entry.getValue();
                boolean isJsonKey = false;
                if (jsonKeys != null && jsonKeys.size() > 0) {
                    for (Object obj : jsonKeys) {
                        if (obj == null || !key.equals(obj.toString())) continue;
                        isJsonKey = true;
                        break;
                    }
                }
                if (isJsonKey) {
                    value = Jacksons.NON_NULL.toJson(value);
                } else {
                    if (value.getClass().isArray()) {
                        Object[] vals;
                        for (Object val : vals = (Object[])value) {
                            if (val == null) continue;
                            sb.append(key).append(BaseConstants.httpParamTradition != false ? "" : "[]").append("=").append(URLEncoder.encode(val.toString(), "UTF-8")).append("&");
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        for (Object e : (Collection)value) {
                            if (e == null) continue;
                            sb.append(key).append(BaseConstants.httpParamTradition != false ? "" : "[]").append("=").append(URLEncoder.encode(e.toString(), "UTF-8")).append("&");
                        }
                        continue;
                    }
                }
                sb.append(key).append("=").append(URLEncoder.encode(value.toString(), "UTF-8")).append("&");
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '&') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static String addParams2Url(String url, String params) {
        Assert.notBlank(url, "url can not be blank.", new Object[0]);
        if (StringUtils.isBlank((String)params)) {
            return url;
        }
        int index = url.indexOf("?");
        if (index == url.length() - 1) {
            return url + params;
        }
        if (index > -1) {
            return url + "&" + params;
        }
        return url + "?" + params;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return header != null && "XMLHttpRequest".equals(header);
    }

    public static boolean isResponseJson(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        return accept != null && accept.trim().startsWith("application/json");
    }

    public static boolean isResponseHtml(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        return accept != null && accept.trim().startsWith("text/html");
    }

    public static void addCookie(String name, String value, HttpServletResponse response) {
        HttpUtils.addCookie(name, value, null, response);
    }

    public static void addCookie(String name, String value, Integer maxAge, HttpServletResponse response) {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                value = URLEncoder.encode(value, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)"HttpUtil class addCookie method error.", e);
            }
        }
        Cookie cookie = new Cookie(name, value);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
    }

    public static String getCookieVal(String cookieName, HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        Cookie c = WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
        if (c != null) {
            return c.getValue() == null ? null : c.getValue().trim();
        }
        return null;
    }

    public static <T> T getCookieVal(String cookieName, HttpServletRequest request, Class<T> clazz) {
        if (request == null) {
            return null;
        }
        Cookie c = WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
        if (c != null && c.getValue() != null) {
            return DataConvert.convertType(c.getValue().trim(), clazz);
        }
        return null;
    }

    public static void removeCookie(String cookieName, HttpServletResponse response) {
        Cookie cookie = new Cookie(cookieName, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outString(String str, HttpServletResponse response) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.write(str);
        }
        catch (IOException e) {
            LOG.error("The method outString in HttpUtil:" + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    public static void outObject(Object obj, HttpServletResponse response) {
        try {
            JsonGenerator jsonGenerator = Jacksons.COMMUNICATE.getFactory().createGenerator((Writer)response.getWriter());
            Jacksons.COMMUNICATE.writeValue(jsonGenerator, obj);
        }
        catch (Exception e) {
            LOG.error("The method outString in HttpUtil:" + e.getMessage());
        }
    }

    public static void outPlainString(String str, HttpServletResponse response) {
        response.setContentType("text/plain");
        HttpUtils.outString(str, response);
    }

    public static void outPlainString(Object obj, HttpServletResponse response) {
        response.setContentType("text/plain");
        HttpUtils.outObject(obj, response);
    }

    public static void outJs(String str, HttpServletResponse response) {
        response.setContentType("text/javascript;charset=UTF-8");
        HttpUtils.outString(str, response);
    }

    public static void outJs(Object obj, HttpServletResponse response) {
        response.setContentType("text/javascript;charset=UTF-8");
        HttpUtils.outObject(obj, response);
    }

    public static void outXml(String str, HttpServletResponse response) {
        response.setContentType("application/xml;charset=UTF-8");
        HttpUtils.outString(str, response);
    }

    public static void outXml(Object obj, HttpServletResponse response) {
        response.setContentType("application/xml;charset=UTF-8");
        HttpUtils.outObject(obj, response);
    }

    public static void outHtml(String str, HttpServletResponse response) {
        response.setContentType("text/html;charset=UTF-8");
        HttpUtils.outString(str, response);
    }

    public static void outHtmlJs(String str, HttpServletResponse response) {
        response.setContentType("text/html;charset=UTF-8");
        StringBuilder sb = new StringBuilder().append("<script type=\"text/javascript\">").append(str).append("</script>");
        HttpUtils.outString(sb.toString(), response);
    }

    public static void outHtml(Object obj, HttpServletResponse response) {
        response.setContentType("text/html;charset=UTF-8");
        HttpUtils.outObject(obj, response);
    }

    public static void outJson(String str, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        HttpUtils.outString(str, response);
    }

    public static void outJson(Object obj, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        HttpUtils.outObject(obj, response);
    }

    public static class Request {
        public static String get(String url) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.get(url, false);
        }

        public static String get(String url, boolean asyn) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.get(url, asyn, null);
        }

        public static String get(String url, boolean asyn, Map<String, ?> params) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.get(url, asyn, params, null);
        }

        public static String get(String url, boolean asyn, Map<String, ?> params, Collection<Object> jsonKeys) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.get(url, asyn, params, jsonKeys, "UTF-8");
        }

        public static String get(final String url, boolean asyn, final Map<String, ?> params, final Collection<Object> jsonKeys, final String charset) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            if (asyn) {
                ExecutorService e = Executors.newSingleThreadExecutor();
                Future<String> f = e.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        try {
                            return Request.get(url, params, jsonKeys, charset);
                        }
                        catch (Exception e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)("get " + url + " request error."), e);
                            }
                            throw e;
                        }
                    }
                });
                e.shutdown();
                return f.get();
            }
            return Request.get(url, params, jsonKeys, charset);
        }

        public static String get(String url, Map<String, ?> params, Collection<Object> jsonKeys, String charset) throws ClientProtocolException, IOException {
            if (StringUtils.isBlank((String)url)) {
                return null;
            }
            if (params != null && !params.isEmpty()) {
                String paramStr = HttpUtils.assembleParams(params, jsonKeys, new String[0]);
                url = HttpUtils.addParams2Url(url, paramStr);
            }
            HttpGet httpGet = new HttpGet(url);
            return Request.execute((HttpUriRequest)httpGet, charset);
        }

        public static String post(String url) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.post(url, false);
        }

        public static String post(String url, boolean asyn) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.post(url, asyn, null);
        }

        public static String post(String url, boolean asyn, Map<String, ?> params) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.post(url, asyn, params, null);
        }

        public static String post(String url, boolean asyn, Map<String, ?> params, Collection<Object> jsonKeys) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            return Request.post(url, asyn, params, jsonKeys, "UTF-8");
        }

        public static String post(final String url, boolean asyn, final Map<String, ?> params, final Collection<?> jsonKeys, final String charset) throws ClientProtocolException, IOException, InterruptedException, ExecutionException {
            if (asyn) {
                ExecutorService e = Executors.newSingleThreadExecutor();
                Future<String> f = e.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        try {
                            return Request.post(url, params, jsonKeys, charset);
                        }
                        catch (Exception e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)("post " + url + " request error."), e);
                            }
                            throw e;
                        }
                    }
                });
                e.shutdown();
                return f.get();
            }
            return Request.post(url, params, jsonKeys, charset);
        }

        public static String post(String url, Map<String, ?> params, Collection<?> jsonKeys, String charset) throws ClientProtocolException, IOException {
            if (StringUtils.isBlank((String)url)) {
                return null;
            }
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    Object value;
                    String key = entry.getKey();
                    boolean isJsonKey = false;
                    if (jsonKeys != null && jsonKeys.size() > 0) {
                        for (Object jsonKey : jsonKeys) {
                            if (jsonKey == null || !jsonKey.toString().equals(key)) continue;
                            isJsonKey = true;
                            break;
                        }
                    }
                    if ((value = isJsonKey ? Jacksons.NON_NULL.toJson(entry.getValue()) : entry.getValue()) == null) continue;
                    if (value.getClass().isArray()) {
                        Object[] vals;
                        for (Object val : vals = (Object[])value) {
                            if (val == null) continue;
                            pairs.add(new BasicNameValuePair(key, val.toString()));
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        for (Object val : (Collection)value) {
                            if (val == null) continue;
                            pairs.add(new BasicNameValuePair(key, val.toString()));
                        }
                        continue;
                    }
                    pairs.add(new BasicNameValuePair(key, value.toString()));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            return Request.execute((HttpUriRequest)httpPost, charset);
        }

        public static String multipart(String url, List<UploadFileInfo> files, Map<String, ?> params) throws ClientProtocolException, IOException {
            return Request.multipart(url, files, params, "UTF-8");
        }

        public static String multipart(String url, List<UploadFileInfo> files, Map<String, ?> params, String charset) throws ClientProtocolException, IOException {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(Charset.forName(charset));
            if (params != null && params.size() > 0) {
                for (String key : params.keySet()) {
                    Object value = params.get(key);
                    if (value == null) continue;
                    if (value.getClass().isArray()) {
                        Object[] vals;
                        for (Object val : vals = (Object[])value) {
                            if (val == null) continue;
                            builder.addTextBody(key, val.toString());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        for (Object val : (Collection)value) {
                            if (val == null) continue;
                            builder.addTextBody(key, val.toString());
                        }
                        continue;
                    }
                    builder.addTextBody(key, value.toString());
                }
            }
            if (files != null && files.size() > 0) {
                for (UploadFileInfo file : files) {
                    String filename;
                    Assert.notNull((Object)file.getParamKey(), "paramKey can not be null.", new Object[0]);
                    Assert.isTrue(file.getFile() != null || file.getInputStream() != null, "file data is null.", new Object[0]);
                    String string = file.getName() == null ? (file.getFile() == null ? System.currentTimeMillis() + ".tmp" : file.getName()) : (filename = file.getName());
                    if (file.getInputStream() != null) {
                        builder.addBinaryBody(file.getParamKey(), file.getInputStream(), ContentType.DEFAULT_BINARY, filename);
                        continue;
                    }
                    builder.addPart(file.getParamKey(), (ContentBody)new FileBody(file.getFile(), ContentType.DEFAULT_BINARY, filename));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(builder.build());
            return Request.execute((HttpUriRequest)httpPost, charset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String execute(HttpUriRequest request, final String charset) throws ClientProtocolException, IOException {
            try (CloseableHttpClient httpClient = null;){
                httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                    public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        int status = response.getStatusLine().getStatusCode();
                        if (status >= 200 && status < 300) {
                            HttpEntity entity = response.getEntity();
                            return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)charset) : null;
                        }
                        throw new ClientProtocolException("Unexpected response status: " + status);
                    }
                };
                String string = (String)httpClient.execute(request, (ResponseHandler)responseHandler);
                return string;
            }
        }
    }
}

