/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class InetAddresses {
    public static String getLocalIp() throws SocketException {
        InetAddress addr = InetAddresses.getLocalAddress();
        return addr == null ? null : addr.getHostAddress();
    }

    public static InetAddress getLocalAddress() throws SocketException {
        List<InetAddress> addrs = InetAddresses.getLocalAddresses();
        return addrs.size() > 0 ? addrs.get(0) : null;
    }

    public static List<String> getLocalIps() throws SocketException {
        List<InetAddress> addrs = InetAddresses.getLocalAddresses();
        ArrayList<String> ips = new ArrayList<String>();
        for (InetAddress addr : addrs) {
            ips.add(addr.getHostAddress());
        }
        return ips;
    }

    public static List<InetAddress> getLocalAddresses() throws SocketException {
        ArrayList<InetAddress> all = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            if (ni.isLoopback() || ni.isVirtual() || !ni.isUp()) continue;
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress() || !addr.isSiteLocalAddress()) continue;
                all.add(addr);
            }
        }
        return all;
    }
}

