/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.net;

import com.easycodebox.common.enums.entity.PhoneType;
import com.easycodebox.common.net.UserAgentDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentParser {
    private String userAgentString;
    private String browserName;
    private String browserVersion;
    private String browserOperatingSystem;
    private PhoneType smartPhoneType;
    private List<UserAgentDetails> parsedBrowsers = new ArrayList<UserAgentDetails>();
    private static String AGENT_MODEL = "\\s*([\\s:\\w\\.-]+)([/]|\\s*)([\\w\\.-]*)\\s*(\\[[a-zA-Z][a-zA-Z]\\])?\\s*(\\(((([^\\(\\)]+|(\\([^\\(\\)]+\\)));?)+)\\))?\\s?";
    private static String IE_MODEL = "MSIE\\s*(.*?);";
    private static Pattern PATTERN = Pattern.compile(AGENT_MODEL);
    public static String FF10 = "Mozilla/5.0 (Windows NT 5.1; rv:10.0) Gecko/20100101 Firefox/10.0";
    public static String IE8 = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1)";
    public static String CHROME = "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11";
    public static String OPERA1 = "Opera/9.27 (Windows NT 5.2; U; zh-cn) ";
    public static String OPERA2 = "Mozilla/5.0 (Macintosh; PPC Mac OS X; U; en) Opera 8.0  ";
    public static String SAFARI1 = "Mozilla/5.0 (Windows; U; Windows NT 5.2) AppleWebKit/525.13 (KHTML, like Gecko) Version/3.1 Safari/525.13 ";
    public static String SAFARI2 = "Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_0 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7A341 Safari/528.16";
    public static String DOCOMO = "DoCoMo/2.0 N02B(c500;TB;W24H16;ser353151031393402;icc8981100020717929442F)";
    public static String SOFTBANK1 = "SoftBank/1.0/941P/PJP10/SN358861030569837 Browser/NetFront/3.4 Profile/MIDP-2.0 Configuration/CLDC-1.1";
    public static String SOFRBANK2 = "J-PHONE/4.0/J-SH51/SN12345678901 SH/0001a Profile/MIDP-1.0 Configuration/CLDC-1.0  ";
    public static String SOFRBANK3 = "Vodafone/1.0/V904SH/SHJ001/SN123456789012345 Browser/VF-NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1 ";
    public static String AU1 = "KDDI-SH3G UP.Browser/6.2_7.2.7.1.K.5.176 (GUI) MMP/2.0";
    public static String AU2 = "UP.Browser/3.04-SN12 UP.Link/3.4.4  ";
    public static String NETFRONT = "Mozilla/3.0 (WILLCOM;KYOCERA/WX03K/2;1.0.2.7.000000/1/C256) NetFront/3.4";
    public static String NETSCAPE = "Mozilla/5.0 (Windows; U; Win 9x 4.90; SG; rv:1.9.2.4) Gecko/20101104 Netscape/9.1.0285";
    public static String CAMINO = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; en; rv:1.9.2.14pre) Gecko/20101212 Camino/2.1a1pre (like Firefox/3.6.14pre)";
    public static String GALENON = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.0.8) Gecko/20090327 Galeon/2.0.7";

    public UserAgentParser(String userAgentString) {
        this.userAgentString = userAgentString;
        this.setSmartPhoneType(userAgentString);
        UserAgentDetails d = UserAgentParser.parseUserAgent(userAgentString);
        if (d != null) {
            this.browserName = d.getBrowserName();
            this.browserVersion = d.getBrowserVersion();
            String temp = this.browserName.trim().toLowerCase();
            this.browserOperatingSystem = temp.equals("docomo") || temp.equals("softbank") || temp.equals("au") ? d.getBrowserComments() : this.extractOperatingSystem(d.getBrowserComments());
        } else {
            this.browserName = "";
            this.browserOperatingSystem = "";
            this.browserVersion = "";
        }
    }

    public static UserAgentDetails parseUserAgent(String userAgentString) {
        Matcher matcher = PATTERN.matcher(userAgentString);
        String brower_name = null;
        String brower_version = null;
        String brower_compents = null;
        if (matcher.find()) {
            String buffer = matcher.group(1).trim().toLowerCase();
            brower_name = matcher.group(1);
            brower_version = matcher.group(3);
            brower_compents = matcher.group(6);
            if (buffer.equals("opera")) {
                brower_name = matcher.group(1);
                brower_version = matcher.group(3);
                brower_compents = matcher.group(6);
                return new UserAgentDetails(brower_name, brower_version, brower_compents);
            }
            if (buffer.equals("docomo")) {
                brower_name = matcher.group(1);
                brower_version = matcher.group(3);
                if (matcher.find()) {
                    brower_compents = matcher.group(1) + matcher.group(3);
                }
                return new UserAgentDetails(brower_name, brower_version, brower_compents);
            }
            if (buffer.equals("j-phone") || buffer.equals("vodafone") || buffer.equals("softbank")) {
                brower_name = "SoftBank";
                brower_version = matcher.group(3);
                if (matcher.find()) {
                    brower_compents = matcher.group(1);
                }
                return new UserAgentDetails(brower_name, brower_version, brower_compents);
            }
            if (buffer.equals("up.browser")) {
                brower_name = "AU";
                buffer = matcher.group(3);
                if (buffer != null && !buffer.trim().equals("")) {
                    String[] temp = buffer.split("-");
                    brower_compents = temp[1];
                    brower_version = temp[0];
                }
                return new UserAgentDetails(brower_name, brower_version, brower_compents);
            }
            if (buffer.startsWith("kddi")) {
                String[] temp = buffer.split("-");
                brower_name = "AU";
                brower_compents = temp[1];
                brower_version = matcher.group(3);
                return new UserAgentDetails(brower_name, brower_version, brower_compents);
            }
            if (buffer.equals("mozilla")) {
                buffer = matcher.group(6);
                if (buffer == null || buffer.trim().equals("")) {
                    return null;
                }
                brower_compents = buffer;
                brower_name = matcher.group(1);
                brower_version = matcher.group(3);
                Pattern p = Pattern.compile(IE_MODEL);
                Matcher m = p.matcher(buffer);
                if (m.find()) {
                    brower_name = "IE";
                    brower_version = m.group(1);
                    return new UserAgentDetails(brower_name, brower_version, brower_compents);
                }
                if (matcher.find()) {
                    buffer = matcher.group(1);
                    brower_name = matcher.group(1);
                    brower_version = matcher.group(3);
                    if (buffer != null && !buffer.trim().equals("")) {
                        if (buffer.trim().toLowerCase().equals("applewebkit")) {
                            if (matcher.find() && (buffer = matcher.group(1)) != null && !buffer.trim().equals("") && buffer.trim().toLowerCase().equals("chrome")) {
                                brower_name = matcher.group(1);
                                brower_version = matcher.group(3);
                                return new UserAgentDetails(brower_name, brower_version, brower_compents);
                            }
                        } else if (buffer.trim().toLowerCase().startsWith("opera")) {
                            String[] temp = buffer.split(" ");
                            brower_name = temp[0];
                            brower_version = temp[1];
                            return new UserAgentDetails(brower_name, brower_version, brower_compents);
                        }
                        while (matcher.find()) {
                            brower_name = matcher.group(1);
                            brower_version = matcher.group(3);
                        }
                        return new UserAgentDetails(brower_name, brower_version, brower_compents);
                    }
                }
            }
            return new UserAgentDetails(brower_name, brower_version, brower_compents);
        }
        return null;
    }

    private void setSmartPhoneType(String userAgentString) {
        this.smartPhoneType = userAgentString.indexOf("iPad") != -1 ? PhoneType.IPAD : (userAgentString.indexOf("Android") != -1 ? PhoneType.ANDROID : (userAgentString.indexOf("iPhone") != -1 ? PhoneType.IPHONE : PhoneType.OTHER));
    }

    private void processBrowserDetails() {
        String[] browserNameAndVersion = this.extractBrowserNameAndVersion();
        this.browserName = browserNameAndVersion[0];
        this.browserVersion = browserNameAndVersion[1];
        this.browserOperatingSystem = this.extractOperatingSystem(this.parsedBrowsers.get(0).getBrowserComments());
    }

    private String[] extractBrowserNameAndVersion() {
        String[] knownBrowsers = new String[]{"firefox", "netscape", "chrome", "safari", "camino", "mosaic", "opera", "galeon"};
        for (UserAgentDetails nextBrowser : this.parsedBrowsers) {
            for (String nextKnown : knownBrowsers) {
                if (!nextBrowser.getBrowserName().toLowerCase().startsWith(nextKnown)) continue;
                return new String[]{nextBrowser.getBrowserName(), nextBrowser.getBrowserVersion()};
            }
        }
        UserAgentDetails firstAgent = this.parsedBrowsers.get(0);
        if (firstAgent.getBrowserName().toLowerCase().startsWith("mozilla")) {
            String[] comments;
            if (firstAgent.getBrowserComments() != null && (comments = firstAgent.getBrowserComments().split(";")).length > 2 && comments[0].toLowerCase().startsWith("compatible")) {
                String realBrowserWithVersion = comments[1].trim();
                int firstSpace = realBrowserWithVersion.indexOf(32);
                int firstSlash = realBrowserWithVersion.indexOf(47);
                if (firstSlash > -1 && firstSpace > -1 || firstSlash > -1 && firstSpace == -1) {
                    return new String[]{realBrowserWithVersion.substring(0, firstSlash), realBrowserWithVersion.substring(firstSlash + 1)};
                }
                if (firstSpace > -1) {
                    return new String[]{realBrowserWithVersion.substring(0, firstSpace), realBrowserWithVersion.substring(firstSpace + 1)};
                }
                return new String[]{realBrowserWithVersion, null};
            }
            Float f = new Float(firstAgent.getBrowserVersion());
            if ((double)f.floatValue() < 5.0) {
                return new String[]{"Netscape", firstAgent.getBrowserVersion()};
            }
            return new String[]{"Mozilla", firstAgent.getBrowserComments().split(";")[0].trim()};
        }
        return new String[]{firstAgent.getBrowserName(), firstAgent.getBrowserVersion()};
    }

    private String extractOperatingSystem(String comments) {
        String[] parts;
        if (comments == null) {
            return null;
        }
        String[] knownOS = new String[]{"win", "linux", "mac", "freebsd", "netbsd", "openbsd", "sunos", "amiga", "beos", "irix", "os/2", "warp", "iphone", "willcom", "ipad", "ipod"};
        ArrayList<String> osDetails = new ArrayList<String>();
        for (String comment : parts = comments.split(";")) {
            String lowerComment = comment.toLowerCase().trim();
            for (String os : knownOS) {
                if (!lowerComment.startsWith(os)) continue;
                osDetails.add(comment.trim());
            }
        }
        switch (osDetails.size()) {
            case 0: {
                return comments;
            }
            case 1: {
                return (String)osDetails.get(0);
            }
        }
        return (String)osDetails.get(0);
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public String getBrowserOperatingSystem() {
        return this.browserOperatingSystem;
    }

    public PhoneType getSmartPhoneType() {
        return this.smartPhoneType;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public static void main(String[] args) {
        UserAgentParser p = new UserAgentParser("Mozilla/5.0 (iPad; CPU OS 5_1 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9B176 Safari/7534.48.3");
        System.out.println(p.getBrowserName());
        System.out.println(p.getBrowserVersion());
        System.out.println(p.getBrowserOperatingSystem());
    }
}

