/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.processor;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.file.Resources;
import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.lang.reflect.ClassUtils;
import com.easycodebox.common.lang.reflect.FieldUtils;
import com.easycodebox.common.processor.Processor;
import com.easycodebox.common.processor.StaticValue;
import com.easycodebox.common.validate.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticValueProcessor
implements Processor {
    private final Pattern pattern = Pattern.compile("^\\s*\\$\\s*\\{\\s*([\\w\\._\\-]+)\\s*\\}\\s*$");
    private String[] packagesToScan;
    private String[] classes;
    private Properties properties;

    @Override
    public Object process() {
        Assert.notNull(this.properties);
        try {
            List<Class<?>> pkgClasses = Resources.scanClass(this.packagesToScan);
            for (Class<?> clazz : pkgClasses) {
                this.processStaticValue(clazz);
            }
            if (this.classes != null) {
                for (String clazz : this.classes) {
                    this.processStaticValue(ClassUtils.getClass((String)clazz));
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return null;
    }

    private void processStaticValue(Class<?> clazz) throws IllegalAccessException {
        Field[] fields = clazz.getFields();
        if (fields == null) {
            return;
        }
        for (Field field : fields) {
            Matcher m;
            String str;
            StaticValue value;
            if (!Modifier.isStatic(field.getModifiers()) || (value = field.getAnnotation(StaticValue.class)) == null || (str = value.value()) == null || !(m = this.pattern.matcher(str)).find()) continue;
            String key = m.group(1);
            String val = this.properties.getProperty(key);
            if (val != null) {
                FieldUtils.writeStaticField((Field)field, DataConvert.convertType(val, field.getType()));
                continue;
            }
            Object originalVal = field.get(null);
            if (originalVal == null) continue;
            this.properties.setProperty(key, originalVal.toString());
        }
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public String[] getClasses() {
        return this.classes;
    }

    public void setClasses(String[] classes) {
        this.classes = classes;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

