/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.rmi;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class LookupRemote {
    private static final Logger LOG = LoggerFactory.getLogger(LookupRemote.class);

    public static <T> T lookup(Class<T> result, String rmiIp) {
        try {
            return (T)Naming.lookup("rmi://" + rmiIp + ":" + 1099 + "/" + result.getSimpleName());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"LookupRemote for {0} error.", e, result.getSimpleName());
        }
        catch (RemoteException e) {
            LOG.error((Object)"LookupRemote for {0} error.", e, result.getSimpleName());
        }
        catch (NotBoundException e) {
            LOG.error((Object)"LookupRemote for {0} error.", e, result.getSimpleName());
        }
        return null;
    }
}

