/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.rmi;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMISocketFactory;
import java.util.List;

public class RemoteFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFactory.class);
    public static final int REGISTRY_PORT = 1099;
    public static final int SEND_MSG_PORT = 1100;
    private List<Remote> remotes;

    public RemoteFactory() {
        try {
            RMISocketFactory.setSocketFactory(new FixPortRMISocketFactory());
            LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException e) {
            LOG.error((Object)"Registry RMI error.", e);
        }
        catch (IOException e) {
            LOG.error((Object)"Setting rmi socket factory error.", e);
        }
    }

    public void createRemote() {
        Assert.notBlank(BaseConstants.rmiIp, "rmiIp param can not be blank.", new Object[0]);
        if (this.remotes == null || this.remotes.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < this.remotes.size(); ++i) {
                Naming.bind("rmi://" + BaseConstants.rmiIp + ":" + 1099 + "/" + this.remotes.get(i).getClass().getInterfaces()[0].getSimpleName(), this.remotes.get(i));
            }
        }
        catch (RemoteException e) {
            LOG.error((Object)"RemoteFactory  createRemote error.", e);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"RemoteFactory  createRemote error.", e);
        }
        catch (AlreadyBoundException e) {
            LOG.error((Object)"RemoteFactory  createRemote error.", e);
        }
    }

    public void setRemotes(List<Remote> remotes) {
        this.remotes = remotes;
    }

    static class FixPortRMISocketFactory
    extends RMISocketFactory {
        FixPortRMISocketFactory() {
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return new Socket(host, port);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            port = port == 0 ? 1100 : port;
            return new ServerSocket(port);
        }
    }
}

