/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.security;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.lang.dto.UserInfo;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.net.InetAddresses;
import com.easycodebox.common.security.SecurityContext;
import com.easycodebox.common.security.SecurityContexts;
import java.net.InetAddress;
import java.net.SocketException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static volatile String serverId = null;

    public static boolean isSecurity() {
        return SecurityUtils.getUserId() != null;
    }

    public static String getUserId() {
        UserInfo user = SecurityUtils.getUser();
        if (user == null) {
            LOG.debug("User info can't obtion.");
            return null;
        }
        return user.getUserId();
    }

    public static String getIp() {
        SecurityContext<UserInfo> context = SecurityUtils.getCurSecurityContext();
        if (context == null) {
            return null;
        }
        return context.getIp();
    }

    public static SecurityContext<UserInfo> getCurSecurityContext() {
        return SecurityContexts.getCurSecurityContext();
    }

    public static String getSessionId() {
        return SecurityUtils.getCurSecurityContext() == null ? null : SecurityUtils.getCurSecurityContext().getSessionId();
    }

    public static void setUser(HttpSession session, UserInfo user) {
        if (session == null) {
            return;
        }
        session.setAttribute(BaseConstants.USER_KEY, (Object)user);
        SecurityContext<UserInfo> sc = SecurityUtils.getCurSecurityContext();
        if (sc == null) {
            SecurityContext<UserInfo> tmp = new SecurityContext<UserInfo>();
            tmp.setSessionId(session.getId());
            tmp.setSecurity(user);
            SecurityContexts.setCurSecurityContext(tmp);
        } else {
            sc.setSecurity(user);
            sc.setSessionId(session.getId());
        }
    }

    public static UserInfo getUser(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (UserInfo)session.getAttribute(BaseConstants.USER_KEY);
    }

    public static void invalidSession(HttpSession session) {
        if (session == null) {
            return;
        }
        session.invalidate();
    }

    public static UserInfo getUser() {
        SecurityContext<UserInfo> context = SecurityUtils.getCurSecurityContext();
        if (context == null || context.getSecurity() == null) {
            return null;
        }
        return context.getSecurity();
    }

    public static String getOperator() {
        UserInfo user = SecurityUtils.getUser();
        if (user == null) {
            LOG.debug("User info can't obtion.");
            return null;
        }
        return user.getOperator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getServerId() {
        if (serverId != null) return serverId;
        LOG.info("SystemInfoUtils.getFrontId <<<DEBUG>>> is NULL !!!");
        Class<SecurityUtils> clazz = SecurityUtils.class;
        synchronized (SecurityUtils.class) {
            if (serverId != null) return serverId;
            LOG.info("<<<DEBUG>>> SystemInfoUtils init frontId start !!!");
            String tomcatId = System.getProperty("tomcat.id");
            if (StringUtils.isNotBlank((String)tomcatId)) {
                LOG.info("<<<DEBUG>>> ==>tomcatId==" + tomcatId);
                serverId = tomcatId;
            } else {
                try {
                    InetAddress addr = InetAddresses.getLocalAddress();
                    serverId = addr.getHostName();
                }
                catch (SocketException e) {
                    LOG.error((Object)"SystemInfoUtils <<<ERROR>>> InetAddresses.getLocalAddress ", e);
                }
                LOG.info("<<<DEBUG>>> ==>HostName==" + serverId);
            }
            if (serverId == null) {
                LOG.error("SystemInfoUtils.getFrontId <<<ERROR>>> frontId=" + serverId);
            }
            LOG.info("SystemInfoUtils init  frontId end !!!");
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverId;
        }
    }

    public static String getUserLoginCookie(String userId, String password) {
        StringBuilder userInfo = new StringBuilder();
        userInfo.append(userId).append("_").append(password).append("_").append(DigestUtils.md5Hex((String)userInfo.toString()));
        return userInfo.toString();
    }

    public static void addUserLoginCookie(String freeLoginCookieName, String userId, Integer freeLoginCookieTime, String password, HttpServletResponse response) {
        String cookie = SecurityUtils.getUserLoginCookie(userId, password);
        HttpUtils.addCookie(freeLoginCookieName, cookie, freeLoginCookieTime, response);
    }

    public static void destroySecurityData(HttpSession session) {
        session.removeAttribute(BaseConstants.USER_KEY);
        SecurityContexts.setCurSecurityContext(null);
    }
}

