/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.security;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class SessionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionPool.class);
    private static ConcurrentMap<String, HttpSession> dataMap = new ConcurrentHashMap<String, HttpSession>();

    public static void addSession(HttpSession session) {
        if (session == null) {
            LOGGER.info("session is null,session:" + session);
            return;
        }
        dataMap.put(session.getId(), session);
        LOGGER.info((Object)"insert session into SessionPool.sessionId:{0}\tsession:{1}", session.getId(), session);
    }

    public static void remove(String sessionId) {
        if (StringUtils.isBlank((String)sessionId)) {
            return;
        }
        HttpSession session = (HttpSession)dataMap.get(sessionId);
        if (null != session) {
            dataMap.remove(sessionId);
            LOGGER.info((Object)"remove session from SessionPool.sessionId:{0}", session.getId());
        }
    }

    public static HttpSession getSession(String sessionId) {
        if (StringUtils.isBlank((String)sessionId)) {
            return null;
        }
        return (HttpSession)dataMap.get(sessionId);
    }
}

