/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.spring;

import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.spring.ApplicationContextFactory;
import com.easycodebox.common.validate.Assert;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class BeanFactory {
    public static Object getBean(String name) throws BeansException {
        ApplicationContext context = ApplicationContextFactory.newInstance();
        Assert.notNull(context);
        return context.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        ApplicationContext context = ApplicationContextFactory.newInstance();
        Assert.notNull(context);
        return (T)context.getBean(name, requiredType);
    }

    public static <T> T getBean(Class<T> requiredType) throws BeansException {
        Object bean = null;
        try {
            bean = BeanFactory.getBean(StringUtils.uncapitalize((String)requiredType.getSimpleName()));
        }
        catch (Exception e) {
            ApplicationContext context = ApplicationContextFactory.newInstance();
            Assert.notNull(context);
            bean = context.getBean(requiredType);
        }
        return (T)bean;
    }
}

