/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.tag.TagExt;
import java.util.Map;

public abstract class AbstractHtmlTag
extends TagExt {
    private static final long serialVersionUID = 5416226129998370809L;
    protected String name;
    protected String title;
    protected String cssClass;
    protected String cssStyle;
    protected String disabled;
    protected String tagAttr;
    protected Map<String, Object> tagAttrMap = null;
    private static final String ALL_KEY = "all";
    private static final String FIRST_KEY = "first";
    private static final String LAST_KEY = "last";
    protected String onblur;
    protected String onchange;
    protected String onclick;
    protected String ondblclick;
    protected String onfocus;
    protected String onkeydown;
    protected String onkeypress;
    protected String onkeyup;
    protected String onmousedown;
    protected String onmousemove;
    protected String onmouseout;
    protected String onmouseover;
    protected String onmouseup;
    protected String onselect;

    @Override
    protected void init() {
        this.onselect = null;
        this.onmouseup = null;
        this.onmouseover = null;
        this.onmouseout = null;
        this.onmousemove = null;
        this.onmousedown = null;
        this.onkeyup = null;
        this.onkeypress = null;
        this.onkeydown = null;
        this.onfocus = null;
        this.ondblclick = null;
        this.onclick = null;
        this.onchange = null;
        this.onblur = null;
        this.tagAttr = null;
        this.disabled = null;
        this.cssStyle = null;
        this.cssClass = null;
        this.title = null;
        this.name = null;
        super.init();
    }

    protected String generateHtml() {
        StringBuilder sb = new StringBuilder();
        this.appendIfNotNull(sb, "id", this.id);
        sb.append(this.generateHtmlNoID());
        return sb.toString();
    }

    protected String generateHtmlNoID() {
        StringBuilder sb = new StringBuilder();
        this.appendIfNotNull(sb, "name", this.name);
        this.appendIfNotNull(sb, "title", this.title);
        this.appendIfNotNull(sb, "class", this.cssClass);
        this.appendIfNotNull(sb, "style", this.cssStyle);
        this.appendIfNotNull(sb, "disabled", this.disabled);
        this.appendIfNotNull(sb, "onblur", this.onblur);
        this.appendIfNotNull(sb, "onchange", this.onchange);
        this.appendIfNotNull(sb, "onclick", this.onclick);
        this.appendIfNotNull(sb, "ondblclick", this.ondblclick);
        this.appendIfNotNull(sb, "onfocus", this.onfocus);
        this.appendIfNotNull(sb, "onkeydown", this.onkeydown);
        this.appendIfNotNull(sb, "onkeypress", this.onkeypress);
        this.appendIfNotNull(sb, "onkeyup", this.onkeyup);
        this.appendIfNotNull(sb, "onmousedown", this.onmousedown);
        this.appendIfNotNull(sb, "onmousemove", this.onmousemove);
        this.appendIfNotNull(sb, "onmouseout", this.onmouseout);
        this.appendIfNotNull(sb, "onmouseover", this.onmouseover);
        this.appendIfNotNull(sb, "onmouseup", this.onmouseup);
        this.appendIfNotNull(sb, "onselect", this.onselect);
        if (this.tagAttrMap == null) {
            if (StringUtils.isNotBlank((String)this.tagAttr)) {
                sb.append(this.tagAttr).append(" ");
            }
        } else if (this.tagAttrMap.containsKey(ALL_KEY)) {
            sb.append(this.tagAttrMap.get(ALL_KEY)).append(" ");
        }
        return sb.toString();
    }

    protected String checkoutTagAttr(int index, int size) {
        if (this.tagAttrMap == null) {
            return "";
        }
        if (this.tagAttrMap.containsKey(String.valueOf(index))) {
            return this.tagAttrMap.get(String.valueOf(index)).toString();
        }
        if (index == 0 && this.tagAttrMap.containsKey(FIRST_KEY)) {
            return this.tagAttrMap.get(FIRST_KEY).toString();
        }
        if (index == size - 1 && this.tagAttrMap.containsKey(LAST_KEY)) {
            return this.tagAttrMap.get(LAST_KEY).toString();
        }
        return "";
    }

    private StringBuilder appendIfNotNull(StringBuilder sb, String name, String val) {
        if (name != null && val != null) {
            sb.append(" " + name + "='" + val + "' ");
        }
        return sb;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle == null ? null : cssStyle.replaceAll("'", "\"");
    }

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = this.obtainVal(title, String.class);
    }

    public String getOnblur() {
        return this.onblur;
    }

    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public String getOndblclick() {
        return this.ondblclick;
    }

    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    public String getOnfocus() {
        return this.onfocus;
    }

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    public String getOnkeydown() {
        return this.onkeydown;
    }

    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    public String getOnkeypress() {
        return this.onkeypress;
    }

    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    public String getOnkeyup() {
        return this.onkeyup;
    }

    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

    public String getOnmousedown() {
        return this.onmousedown;
    }

    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    public String getOnmousemove() {
        return this.onmousemove;
    }

    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    public String getOnmouseout() {
        return this.onmouseout;
    }

    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    public String getOnmouseover() {
        return this.onmouseover;
    }

    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    public String getOnmouseup() {
        return this.onmouseup;
    }

    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    public String getOnselect() {
        return this.onselect;
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    public String getTagAttr() {
        return this.tagAttr;
    }

    public void setTagAttr(String tagAttr) {
        if (tagAttr != null) {
            if ((tagAttr = tagAttr.trim()).startsWith("{")) {
                try {
                    this.tagAttrMap = Jacksons.COMMUNICATE.toBean(tagAttr, Map.class);
                }
                catch (Exception e) {
                    this.LOG.warn((Object)"Parse json string error.\u3010{0}\u3011", e, tagAttr);
                }
            }
            this.tagAttr = tagAttr;
        }
    }
}

