/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.tag.TagExt;
import com.easycodebox.common.validate.Assert;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.standard.tag.common.core.ParamParent;

public class CacheUrl
extends TagExt
implements ParamParent {
    private static final long serialVersionUID = 1L;
    private Boolean condition;
    private String content;
    private Map<String, String> extraParams = new LinkedHashMap<String, String>(4);
    private String[] excludeParams;

    @Override
    protected void init() {
        this.condition = null;
        this.content = "<script type=\"text/javascript\">%ntry {%n\tif(utils && utils.cacheUrl) {%n\t\tutils.cacheUrl(\"%1$s\");%n\t}else {%n\t\tthrow Error(\"There is no utils.cacheUrl method.\");%n\t}%n}catch(e) {%n\t(function() {%n\t\tvar original = null;%n\t\tif(\"[object Function]\" === Object.prototype.toString.call(window.utilsReady)) {%n\t\t\toriginal = utilsReady;%n\t\t}%n\t\twindow.utilsReady = function() {%n\t\t\tif(original) {%n\t\t\t\toriginal();%n\t\t\t}%n\t\t\tutils.cacheUrl(\"%1$s\");%n\t\t};%n\t})();%n}%n</script>";
        this.extraParams = null;
        this.excludeParams = null;
        super.init();
    }

    public int doStartTag() throws JspException {
        if (this.condition != null && !this.condition.booleanValue()) {
            return 0;
        }
        this.extraParams = new LinkedHashMap<String, String>();
        return super.doStartTag();
    }

    @Override
    public int doEndTag() throws JspException {
        Assert.notNull(this.content);
        StringBuilder params = new StringBuilder();
        if (this.extraParams.size() > 0) {
            Set<String> keys = this.extraParams.keySet();
            for (String key : keys) {
                params.append("&").append(key).append("=").append(this.extraParams.get(key));
            }
        }
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            String url = HttpUtils.getFullRequestUrl(request, true, this.excludeParams);
            url = HttpUtils.addParams2Url(url, params.toString());
            this.pageContext.getOut().append((CharSequence)String.format(this.content, url));
        }
        catch (IOException e) {
            this.LOG.error((Object)"TextCut Tag processing error.", e);
            this.release();
            return 0;
        }
        return super.doEndTag();
    }

    public void addParameter(String name, String value) {
        this.extraParams.put(name, value);
    }

    public Boolean getCondition() {
        return this.condition;
    }

    public void setCondition(Boolean condition) {
        this.condition = condition;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setExcludeParams(String params) {
        if (StringUtils.isNotBlank((String)params)) {
            this.excludeParams = params.trim().split("\\s*,\\s*");
        }
    }
}

