/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.tag.EnumGroupTag;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class CheckboxEnum
extends EnumGroupTag {
    private static final long serialVersionUID = -6544626999455987482L;
    private String labelClass;
    private String labelStyle;
    private String tmpId;

    @Override
    protected void init() {
        this.tmpId = null;
        this.labelStyle = null;
        this.labelClass = null;
        super.init();
    }

    public int doStartTag() throws JspException {
        if (this.begin != null && this.end != null && this.begin > this.end) {
            return 0;
        }
        List<Enum<?>> enumsList = this.getEnumList();
        this.end = this.end == null ? enumsList.size() - 1 : this.end;
        this.tmpId = (this.tmpId == null ? "e_checkbox" : this.tmpId) + "_" + RandomStringUtils.randomAlphanumeric((int)8);
        String html = super.generateHtmlNoID();
        StringBuilder sb = new StringBuilder();
        while (this.begin <= this.end) {
            this.id = this.tmpId + "_" + this.begin;
            Object cur = (DetailEnum)((Object)enumsList.get(this.begin));
            String enumName = ((Enum)cur).name();
            String checkValue = this.dataType.equals("VALUE") ? cur.getValue().toString() : enumName;
            sb.append("<input type='checkbox' value='" + checkValue + "' ");
            sb.append(" id = '" + this.id + "' ").append(html).append(this.checkoutTagAttr(this.begin, this.end + 1));
            if (this.selectedValue != null && (enumName.equals(this.selectedValue) || cur.getValue().toString().equals(this.selectedValue))) {
                sb.append(" checked='checked' ");
            }
            sb.append(" /> ");
            sb.append(" <label ");
            if (StringUtils.isNotBlank((String)this.labelClass)) {
                sb.append(" class='" + this.labelClass + "' ");
            }
            if (StringUtils.isNotBlank((String)this.labelStyle)) {
                sb.append(" style='" + this.labelStyle + "' ");
            }
            sb.append(" for='" + this.id + "' >" + cur.getDesc() + "</label> ").append("&nbsp;&nbsp;");
            cur = this.begin;
            Integer n = this.begin = Integer.valueOf(this.begin + 1);
        }
        try {
            this.pageContext.getOut().append((CharSequence)sb);
        }
        catch (IOException e) {
            this.LOG.error((Object)"RadioEnum Tag processing error.", e);
        }
        return 1;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    public void setId(String id) {
        this.id = this.tmpId = id;
    }
}

