/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.spring.BeanFactory;
import com.easycodebox.common.tag.IdConverter;
import com.easycodebox.common.tag.TagExt;
import com.easycodebox.common.validate.Assert;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.jsp.JspException;

public class ConvertIdTag
extends TagExt {
    private static final long serialVersionUID = 1L;
    private static IdConverterMap converterMap;
    private String module;
    private Object cid;
    private String prop;

    @Override
    protected void init() {
        super.init();
        this.prop = null;
        this.module = null;
        this.cid = null;
        if (converterMap == null) {
            converterMap = BeanFactory.getBean(IdConverterMap.class);
        }
    }

    public int doStartTag() throws JspException {
        try {
            String data = converterMap.convert(this.module, this.cid, this.prop);
            if (data != null) {
                this.pageContext.getOut().append((CharSequence)data);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException.", e);
        }
        return super.doStartTag();
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Object getCid() {
        return this.cid;
    }

    public void setCid(Object cid) {
        this.cid = cid;
    }

    public String getProp() {
        return this.prop;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public static class DefaultIdConverterMap
    implements IdConverterMap {
        private String defaultModule;
        private ConcurrentMap<String, IdConverter> maps = new ConcurrentHashMap<String, IdConverter>(4);

        @Override
        public String convert(String module, Object id, String prop) {
            if (module == null) {
                module = this.defaultModule;
            }
            IdConverter converter = (IdConverter)this.maps.get(module);
            Assert.notNull((Object)converter, "Can't find corresponding module : {0}.", module, new Object[0]);
            Object val = converter.convert(id, prop);
            return val == null ? null : val.toString();
        }

        public void setConverterMap(Map<String, IdConverter> map) {
            if (map != null) {
                this.maps.putAll(map);
            }
        }

        public IdConverter addIdConverter(String key, IdConverter converter) {
            return this.maps.put(key, converter);
        }

        public String getDefaultModule() {
            return this.defaultModule;
        }

        public void setDefaultModule(String defaultModule) {
            this.defaultModule = defaultModule;
        }
    }

    public static interface IdConverterMap {
        public String convert(String var1, Object var2, String var3);
    }
}

