/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.enums.EnumClassFactory;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.tag.TagExt;
import com.easycodebox.common.validate.Assert;
import javax.servlet.jsp.JspException;
import org.apache.commons.beanutils.PropertyUtils;

public class ElseIfEnum
extends TagExt {
    private static final long serialVersionUID = 7440207878254221968L;
    private Object test;
    private String enumValue;
    private String enumProperty;

    @Override
    protected void init() {
        this.enumProperty = null;
        this.enumValue = null;
        this.test = null;
        super.init();
    }

    public int doStartTag() throws JspException {
        Boolean answer;
        Boolean ifResult = (Boolean)this.pageContext.getAttribute("enum.if.answer");
        if (ifResult == null || ifResult.booleanValue()) {
            return 0;
        }
        Assert.notNull(this.test, "test can not be null.", new Object[0]);
        Assert.notBlank(this.enumValue, "enumValue can not be blank.", new Object[0]);
        String[] array = this.enumValue.split("\\.");
        if (array.length != 2) {
            throw new IllegalArgumentException("enumValue error format.");
        }
        Class<? extends Enum<?>> enumClass = EnumClassFactory.newInstance(array[0]);
        Enum<?> e = Enum.valueOf(enumClass, array[1]);
        if (this.enumProperty == null) {
            answer = this.test instanceof String && e.name().equals(this.test) || e.equals(this.test) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            try {
                Object pro = PropertyUtils.getSimpleProperty(e, (String)this.enumProperty);
                answer = pro != null && this.test.toString().equals(pro.toString()) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e1) {
                throw new BaseException("Obtain enum({0}) property({1}) error.", (Throwable)e1, e, this.enumProperty);
            }
        }
        this.pageContext.setAttribute("enum.if.answer", (Object)answer);
        return answer != false ? 1 : 0;
    }

    public void setTest(Object test) {
        this.test = this.obtainVal(test, Object.class);
    }

    public void setEnumValue(String enumValue) {
        this.enumValue = this.obtainVal(enumValue, String.class);
    }

    public void setEnumProperty(String enumProperty) {
        this.enumProperty = this.obtainVal(enumProperty, String.class);
    }
}

