/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.enums.EnumClassFactory;
import com.easycodebox.common.lang.CollectionUtils;
import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.tag.AbstractHtmlTag;
import com.easycodebox.common.validate.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class EnumGroupTag
extends AbstractHtmlTag {
    private static final long serialVersionUID = -1316915840915764647L;
    protected static final String DATA_TYPE_NAME = "NAME";
    protected static final String DATA_TYPE_VALUE = "VALUE";
    protected String dataType;
    protected String enumName;
    protected String selectedValue;
    protected Integer begin;
    protected Integer end;
    protected String[] exclude;
    protected String[] include;

    @Override
    protected void init() {
        this.dataType = DATA_TYPE_NAME;
        this.selectedValue = null;
        this.enumName = null;
        this.begin = 0;
        this.end = null;
        this.include = null;
        this.exclude = null;
        super.init();
    }

    protected List<Enum<?>> getEnumList() {
        List<Enum<?>> enumsList;
        Assert.notNull((Object)this.enumName, "enumName can't be null.", new Object[0]);
        Class<Enum<?>> enumClass = EnumClassFactory.newInstance(this.enumName);
        if (this.include != null && this.include.length > 0) {
            enumsList = new ArrayList(6);
            for (int i = 0; i < this.include.length; ++i) {
                enumsList.add(Enum.valueOf(enumClass, this.include[i]));
            }
        } else {
            Enum<?>[] enums = enumClass.getEnumConstants();
            enumsList = CollectionUtils.toList(enums);
        }
        if (this.exclude != null && this.exclude.length > 0) {
            for (int j = 0; j < this.exclude.length; ++j) {
                Enum<?> e = Enum.valueOf(enumClass, this.exclude[j]);
                enumsList.remove(e);
            }
        }
        return enumsList;
    }

    public void setEnumName(String enumName) {
        this.enumName = this.obtainVal(enumName, String.class);
    }

    public void setSelectedValue(Object selectedValue) {
        Object selected = this.obtainVal(selectedValue, Object.class);
        this.selectedValue = selected == null ? null : (selected instanceof Enum ? ((Enum)selected).name() : selected.toString());
    }

    public void setBegin(Object begin) {
        this.begin = this.obtainVal(begin, Integer.class);
    }

    public void setEnd(Object end) {
        this.end = this.obtainVal(end, Integer.class);
    }

    public void setExclude(String exclude) {
        if (StringUtils.isNotBlank((String)exclude)) {
            Object stackVal = this.obtainVal(exclude, Object.class);
            if (stackVal instanceof String) {
                this.exclude = (String[])DataConvert.convertArray((String)stackVal, String[].class);
            } else if (stackVal instanceof Collection) {
                this.exclude = ((Collection)stackVal).toArray(this.exclude);
            } else if (stackVal.getClass().isArray()) {
                this.exclude = (String[])stackVal;
            }
        }
    }

    public void setInclude(String include) {
        if (StringUtils.isNotBlank((String)include)) {
            Object stackVal = this.obtainVal(include, Object.class);
            if (stackVal instanceof String) {
                this.include = (String[])DataConvert.convertArray((String)stackVal, String[].class);
            } else if (stackVal instanceof Collection) {
                this.include = ((Collection)stackVal).toArray(this.include);
            } else if (stackVal.getClass().isArray()) {
                this.include = (String[])stackVal;
            }
        }
    }

    public void setDataType(String dataType) {
        if (StringUtils.isNotBlank((String)dataType)) {
            this.dataType = dataType.toUpperCase();
        }
    }
}

