/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.lang.RegularUtils;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.tag.AbstractHtmlTag;
import com.easycodebox.common.validate.Assert;
import java.io.IOException;
import javax.servlet.jsp.JspException;

public class ImgUrl
extends AbstractHtmlTag {
    private static final long serialVersionUID = -1586374485223953984L;
    private String root;
    private String url;
    private String mode;
    private String rule;
    private Boolean lazy;
    private Boolean imgTag;
    private String defaultImg = "imgs/util/blank.gif";

    @Override
    protected void init() {
        this.root = BaseConstants.imgUrl;
        this.mode = "ADD";
        this.lazy = false;
        this.imgTag = true;
        this.rule = null;
        this.url = null;
        super.init();
    }

    public int doStartTag() throws JspException {
        Assert.notBlank(this.rule, "rule can't not be null.", new Object[0]);
        this.url = StringUtils.isBlank((String)this.url) ? BaseConstants.Imgs.defaultImg : this.url;
        StringBuilder sb = new StringBuilder(this.root).append("/");
        if (this.mode.equalsIgnoreCase("ADD")) {
            sb.append(RegularUtils.addImgUrlRule(this.url, this.rule.split(",")));
        } else if (this.mode.equalsIgnoreCase("REMOVE")) {
            sb.append(RegularUtils.removeImgUrlRule(this.url, this.rule.split(",")));
        }
        try {
            this.pageContext.getOut().append((CharSequence)this.processContent(sb.toString()));
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException.", e);
        }
        return 1;
    }

    private String processContent(String imgUrl) {
        if (this.imgTag.booleanValue()) {
            StringBuilder sb = new StringBuilder().append("<img " + super.generateHtml()).append(this.lazy != false ? " lazy='" + imgUrl + "' src='" + this.defaultImg + "' " : " src='" + imgUrl + "' ").append(" />");
            imgUrl = sb.toString();
        }
        return imgUrl;
    }

    public void setRoot(String root) {
        this.root = this.obtainVal(root, String.class);
    }

    public void setUrl(String url) {
        this.url = this.obtainVal(url, String.class);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setRule(String rule) {
        this.rule = this.obtainVal(rule, String.class);
    }

    public void setLazy(Object lazy) {
        this.lazy = this.obtainVal(lazy, Boolean.class);
    }

    public void setImgTag(Object imgTag) {
        this.imgTag = this.obtainVal(imgTag, Boolean.class);
    }
}

