/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.enums.Enums;
import com.easycodebox.common.enums.entity.ProjectEnv;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.tag.AbstractHtmlTag;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class LinkTag
extends AbstractHtmlTag {
    private static final long serialVersionUID = -1586374485223953984L;
    private String rel;
    private String type;
    private String href;
    private String media;
    private String sizes;
    private ProjectEnv env;
    private boolean min;

    @Override
    protected void init() {
        this.rel = "stylesheet";
        this.type = "text/css";
        this.env = BaseConstants.projectEnv;
        this.min = BaseConstants.transMinJsCss;
        super.init();
    }

    public int doStartTag() throws JspException {
        StringBuilder sb = new StringBuilder("<link ");
        if (this.rel != null) {
            sb.append("rel=\"").append(this.rel).append("\" ");
        }
        if (this.type != null) {
            sb.append("type=\"").append(this.type).append("\" ");
        }
        if (this.href != null) {
            this.href = this.href.replaceAll("\\s*", "");
            if (this.env != ProjectEnv.DEV && this.min) {
                this.href = this.href.replaceAll("(?<!\\.min)\\.css(?=,|\\?|$)", ".min.css");
            }
            sb.append("href=\"").append(this.env == ProjectEnv.DEV ? "{0}" : this.href).append("\" ");
        }
        if (this.media != null) {
            sb.append("media=\"").append(this.media).append("\" ");
        }
        if (this.sizes != null) {
            sb.append("sizes=\"").append(this.sizes).append("\" ");
        }
        sb.append(super.generateHtml()).append("/>");
        try {
            JspWriter write = this.pageContext.getOut();
            if (this.env == ProjectEnv.DEV) {
                String tag = sb.toString();
                String[] srcFrags = this.href.split("\\?\\?");
                if (srcFrags.length == 1) {
                    write.append((CharSequence)StringUtils.format(tag, this.href));
                } else {
                    String[] files;
                    for (String file : files = srcFrags[1].split(",")) {
                        write.append((CharSequence)StringUtils.format(tag, srcFrags[0] + file));
                    }
                }
            } else {
                write.append((CharSequence)sb.toString());
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException.", e);
        }
        return 1;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public void setSizes(String sizes) {
        this.sizes = sizes;
    }

    public void setEnv(String env) {
        if (StringUtils.isNotBlank((String)env)) {
            this.env = Enums.deserialize(ProjectEnv.class, env, false);
        }
    }

    public void setMin(String min) {
        if (StringUtils.isNotBlank((String)min)) {
            this.min = Boolean.parseBoolean(min);
        }
    }
}

