/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.tag.TagExt;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;

public class Number
extends TagExt {
    private static final long serialVersionUID = 1L;
    private String pattern;
    private Object value;
    private Boolean groupUsed;
    private Integer groupSize;
    private Integer maxFractionDigits;
    private Integer maxIntDigits;
    private Integer minFractionDigits;
    private Integer minIntDigits;
    private Boolean onlyInt;
    private RoundingMode roundingMode;

    @Override
    protected void init() {
        this.pattern = "0.##";
        this.value = null;
        this.groupUsed = false;
        this.minIntDigits = null;
        this.minFractionDigits = null;
        this.maxIntDigits = null;
        this.maxFractionDigits = null;
        this.groupSize = null;
        this.onlyInt = null;
        this.roundingMode = RoundingMode.FLOOR;
        super.init();
    }

    public int doStartTag() throws JspException {
        NumberFormat format = this.getNumberFormat();
        if (this.value == null) {
            this.value = 0;
        } else if (!java.lang.Number.class.isAssignableFrom(this.value.getClass())) {
            this.value = new BigDecimal(this.value.toString());
        }
        String data = format.format(this.value);
        try {
            if (data != null) {
                this.pageContext.getOut().append((CharSequence)data);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException.", e);
        }
        return super.doStartTag();
    }

    private NumberFormat getNumberFormat() {
        NumberFormat format = null;
        if (this.pattern.equalsIgnoreCase("integer")) {
            format = NumberFormat.getIntegerInstance(Locale.getDefault());
        } else if (this.pattern.equalsIgnoreCase("number")) {
            format = NumberFormat.getNumberInstance(Locale.getDefault());
        } else if (this.pattern.equalsIgnoreCase("percent")) {
            format = NumberFormat.getPercentInstance(Locale.getDefault());
        } else if (this.pattern.equalsIgnoreCase("currency")) {
            format = NumberFormat.getCurrencyInstance(Locale.getDefault());
        } else {
            format = new DecimalFormat(this.pattern);
            if (this.groupSize != null) {
                ((DecimalFormat)format).setGroupingSize(this.groupSize);
            }
        }
        if (this.groupUsed != null) {
            format.setGroupingUsed(this.groupUsed);
        }
        if (this.maxFractionDigits != null) {
            format.setMaximumFractionDigits(this.maxFractionDigits);
        }
        if (this.maxIntDigits != null) {
            format.setMaximumIntegerDigits(this.maxIntDigits);
        }
        if (this.minFractionDigits != null) {
            format.setMinimumFractionDigits(this.minFractionDigits);
        }
        if (this.minIntDigits != null) {
            format.setMinimumIntegerDigits(this.minIntDigits);
        }
        if (this.onlyInt != null) {
            format.setParseIntegerOnly(this.onlyInt);
        }
        if (this.roundingMode != null) {
            format.setRoundingMode(this.roundingMode);
        }
        return format;
    }

    public void setPattern(String pattern) {
        this.pattern = this.obtainVal(pattern, String.class);
    }

    public void setValue(Object value) {
        this.value = this.obtainVal(value, Object.class);
    }

    public void setGroupUsed(Object groupUsed) {
        this.groupUsed = this.obtainVal(groupUsed, Boolean.class);
    }

    public void setGroupSize(Object groupSize) {
        this.groupSize = this.obtainVal(groupSize, Integer.class);
    }

    public void setMaxFractionDigits(Object maxFractionDigits) {
        this.maxFractionDigits = this.obtainVal(maxFractionDigits, Integer.class);
    }

    public void setMaxIntDigits(Object maxIntDigits) {
        this.maxIntDigits = this.obtainVal(maxIntDigits, Integer.class);
    }

    public void setMinFractionDigits(Object minFractionDigits) {
        this.minFractionDigits = this.obtainVal(minFractionDigits, Integer.class);
    }

    public void setMinIntDigits(Object minIntDigits) {
        this.minIntDigits = this.obtainVal(minIntDigits, Integer.class);
    }

    public void setOnlyInt(Object onlyInt) {
        this.onlyInt = this.obtainVal(onlyInt, Boolean.class);
    }

    public void setRoundingMode(String roundingMode) {
        this.roundingMode = RoundingMode.valueOf(roundingMode);
    }
}

