/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.tag.AbstractHtmlTag;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.standard.tag.common.core.ParamParent;

public class Page
extends AbstractHtmlTag
implements ParamParent {
    private static final long serialVersionUID = 5561979760457415443L;
    private Integer pageNo;
    private Integer totalPage;
    private Integer showPageNum;
    private String url;
    private String cssClass;
    private String preOmit;
    private String sufOmit;
    private String firstPage;
    private String endPage;
    private String prePage;
    private String nextPage;
    private boolean antoAddParam;
    private Map<String, String> params;

    @Override
    protected void init() {
        this.id = "";
        this.pageNo = this.totalPage = Integer.valueOf(1);
        this.showPageNum = 5;
        this.cssClass = "pagination";
        this.sufOmit = "<span>...</span>";
        this.preOmit = "<span>...</span>";
        this.firstPage = "\u7b2c\u4e00\u9875";
        this.endPage = "\u6700\u540e\u9875";
        this.prePage = "\u4e0a\u4e00\u9875";
        this.nextPage = "\u4e0b\u4e00\u9875";
        this.antoAddParam = true;
        this.params = null;
        super.init();
    }

    public void addParameter(String name, String value) {
        this.params.put(name, value);
    }

    public int doStartTag() throws JspException {
        this.params = new LinkedHashMap<String, String>();
        return super.doStartTag();
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            StringBuilder sb = new StringBuilder();
            StringBuilder paramStr = new StringBuilder();
            Set<String> keys = this.params.keySet();
            for (String key : keys) {
                paramStr.append("&").append(key).append("=").append(this.params.get(key));
            }
            if (this.antoAddParam) {
                HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
                String ps = HttpUtils.getRequestParams(request, true, "flush_cached_uri", "back_cached_uri");
                if ((ps = ps.replaceAll("pageNo=\\d+", "").replace("&&", "&")).length() > 0) {
                    paramStr.append("&").append(ps);
                }
            }
            String param = paramStr.toString();
            if (this.totalPage != 0) {
                sb.append("<ol class='" + this.cssClass + "'>");
                sb.append("<li><a href='");
                sb.append(this.url);
                sb.append("?" + this.id + "pageNo=1" + param);
                sb.append("'>" + this.firstPage + "</a></li>");
                if (this.pageNo == 1) {
                    sb.append("<li class='disabled'><a href='javascript:'>");
                    sb.append(this.prePage);
                    sb.append("</a></li>");
                } else {
                    sb.append("<li><a href='");
                    sb.append(this.url);
                    sb.append("?" + this.id + "pageNo=" + (this.pageNo - 1) + param);
                    sb.append("'>" + this.prePage + "</a></li>");
                }
                if (this.totalPage <= this.showPageNum) {
                    for (int i = 1; i <= this.totalPage; ++i) {
                        String current = "";
                        if (i == this.pageNo) {
                            current = " class='current' ";
                        }
                        sb.append("<li" + current + "><a href='");
                        sb.append(this.url);
                        sb.append("?" + this.id + "pageNo=" + i + param);
                        sb.append("'>" + i + "</a></li>");
                    }
                } else {
                    int end;
                    int start;
                    int sufHalf;
                    int preHalf = this.showPageNum / 2;
                    int n = sufHalf = this.showPageNum % 2 == 0 ? preHalf - 1 : preHalf;
                    if (this.pageNo - preHalf < 1) {
                        start = 1;
                        end = this.showPageNum;
                    } else if (this.pageNo + sufHalf > this.totalPage) {
                        start = this.totalPage - this.showPageNum + 1;
                        end = this.totalPage;
                    } else {
                        start = this.pageNo - preHalf;
                        end = this.pageNo + sufHalf;
                    }
                    if (start > 1) {
                        sb.append("<li>");
                        sb.append(this.preOmit);
                        sb.append("</li>");
                    }
                    for (int i = start; i <= end; ++i) {
                        String current = "";
                        if (i == this.pageNo) {
                            current = " class='current' ";
                        }
                        sb.append("<li" + current + "><a href='");
                        sb.append(this.url);
                        sb.append("?" + this.id + "pageNo=" + i + param);
                        sb.append("'>" + i + "</a></li>");
                    }
                    if (end < this.totalPage) {
                        sb.append("<li>");
                        sb.append(this.sufOmit);
                        sb.append("</li>");
                    }
                }
                if (this.pageNo + 1 > this.totalPage) {
                    sb.append("<li class='disabled'><a href='javascript:'>");
                    sb.append(this.nextPage);
                    sb.append("</a></li>");
                } else {
                    sb.append("<li><a href='");
                    sb.append(this.url);
                    sb.append("?" + this.id + "pageNo=" + (this.pageNo + 1) + param);
                    sb.append("'>" + this.nextPage + "</a></li>");
                }
                sb.append("<li><a href='");
                sb.append(this.url);
                sb.append("?" + this.id + "pageNo=" + this.totalPage + param);
                sb.append("'>" + this.endPage + "</a></li></ol>");
            }
            this.pageContext.getOut().append((CharSequence)sb);
        }
        catch (IOException ex) {
            this.LOG.error((Object)"page the data error!", ex);
            this.release();
            return 0;
        }
        return super.doEndTag();
    }

    public void setPageNo(Object pageNo) {
        this.pageNo = this.obtainVal(pageNo, Integer.class);
    }

    public void setTotalPage(Object totalPage) {
        this.totalPage = this.obtainVal(totalPage, Integer.class);
    }

    public void setUrl(String url) {
        this.url = this.obtainVal(url, String.class);
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setShowPageNum(Object showPageNum) {
        this.showPageNum = this.obtainVal(showPageNum, Integer.class);
    }

    public void setFirstPage(String firstPage) {
        this.firstPage = firstPage;
    }

    public void setEndPage(String endPage) {
        this.endPage = endPage;
    }

    public void setPrePage(String prePage) {
        this.prePage = prePage;
    }

    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    public void setPreOmit(String preOmit) {
        this.preOmit = preOmit;
    }

    public void setSufOmit(String sufOmit) {
        this.sufOmit = sufOmit;
    }

    public void setAntoAddParam(Object antoAddParam) {
        this.antoAddParam = this.obtainVal(antoAddParam, Boolean.class);
    }
}

