/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.enums.Enums;
import com.easycodebox.common.enums.entity.ProjectEnv;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.tag.AbstractHtmlTag;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class ScriptTag
extends AbstractHtmlTag {
    private static final long serialVersionUID = -1586374485223953984L;
    private String type;
    private String src;
    private String charset;
    private String async;
    private String defer;
    private ProjectEnv env;
    private boolean min;

    @Override
    protected void init() {
        this.type = "text/javascript";
        this.env = BaseConstants.projectEnv;
        this.min = BaseConstants.transMinJsCss;
        super.init();
    }

    public int doStartTag() throws JspException {
        StringBuilder sb = new StringBuilder("<script ");
        if (this.type != null) {
            sb.append("type=\"").append(this.type).append("\" ");
        }
        if (this.src != null) {
            this.src = this.src.replaceAll("\\s*", "");
            if (this.env != ProjectEnv.DEV && this.min) {
                this.src = this.src.replaceAll("(?<!\\.min)\\.js(?=,|\\?|$)", ".min.js");
            }
            sb.append("src=\"").append(this.env == ProjectEnv.DEV ? "{0}" : this.src).append("\" ");
        }
        if (this.charset != null) {
            sb.append("charset=\"").append(this.charset).append("\" ");
        }
        if (this.async != null) {
            sb.append("async=\"").append(this.async).append("\" ");
        }
        if (this.defer != null) {
            sb.append("defer=\"").append(this.defer).append("\" ");
        }
        sb.append(super.generateHtml()).append(">");
        try {
            JspWriter write = this.pageContext.getOut();
            if (this.env == ProjectEnv.DEV) {
                String tag = sb.toString();
                String[] srcFrags = this.src.split("\\?\\?");
                if (srcFrags.length == 1) {
                    write.append((CharSequence)StringUtils.format(tag, this.src));
                } else {
                    String[] files = srcFrags[1].split(",");
                    for (int i = 0; i < files.length; ++i) {
                        write.append((CharSequence)StringUtils.format(tag, srcFrags[0] + files[i]));
                        if (i >= files.length - 1) continue;
                        write.append((CharSequence)"</script>");
                    }
                }
            } else {
                write.append((CharSequence)sb.toString());
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException.", e);
        }
        return 1;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            this.pageContext.getOut().append((CharSequence)"</script>");
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException.", e);
        }
        return super.doEndTag();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setAsync(String async) {
        if (StringUtils.isNotBlank((String)async) && ("async".equals(async = async.toLowerCase()) || "true".equals(async))) {
            this.async = "async";
        }
    }

    public void setDefer(String defer) {
        if (StringUtils.isNotBlank((String)defer) && ("defer".equals(defer = defer.toLowerCase()) || "true".equals(defer))) {
            this.defer = "defer";
        }
    }

    public void setEnv(String env) {
        if (StringUtils.isNotBlank((String)env)) {
            this.env = Enums.deserialize(ProjectEnv.class, env, false);
        }
    }

    public void setMin(String min) {
        if (StringUtils.isNotBlank((String)min)) {
            this.min = Boolean.parseBoolean(min);
        }
    }
}

