/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.lang.StringToken;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class TagExt
extends BodyTagSupport {
    private static final long serialVersionUID = 3561443758087661847L;
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String EXP = "^\\s*%\\s*\\{\\s*([\\w\\.]+)\\s*\\}\\s*$";
    private final Pattern expPattern = Pattern.compile("^\\s*%\\s*\\{\\s*([\\w\\.]+)\\s*\\}\\s*$");

    public TagExt() {
        this.init();
    }

    protected void init() {
    }

    public int doEndTag() throws JspException {
        this.release();
        return super.doEndTag();
    }

    public void release() {
        super.release();
        this.init();
    }

    protected <T> T obtainVal(Object name, Class<T> returnClass) {
        if (name == null) {
            return null;
        }
        if (returnClass.isAssignableFrom(name.getClass()) && !String.class.equals(name.getClass())) {
            return (T)name;
        }
        String str = name.toString();
        boolean isExp = false;
        Matcher matcher = this.expPattern.matcher(str);
        if (matcher.find()) {
            isExp = true;
            str = matcher.group(1);
        }
        if (isExp) {
            return (T)this.findAttribute(str);
        }
        return DataConvert.convertType(str, returnClass);
    }

    private Object findAttribute(String key) {
        StringToken.OgnlToken token = new StringToken.OgnlToken(key);
        String tmpKey = token.nextKey();
        Object data = this.pageContext.findAttribute(tmpKey);
        while (data != null && !(tmpKey = token.nextKey()).isEmpty()) {
            if (token.isDynamicKey()) {
                token.resetDynamicKey();
                tmpKey = this.pageContext.findAttribute(tmpKey).toString();
            }
            try {
                data = PropertyUtils.getProperty((Object)data, (String)tmpKey);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.LOG.warn((Object)"Obtain obj({0} -- {1}) property({2}) error.", data.getClass(), data, tmpKey);
                return null;
            }
        }
        return data;
    }

    protected boolean isExp(String value) {
        return this.expPattern.matcher(value).matches();
    }
}

