/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.tag;

import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.lang.TextUtils;
import com.easycodebox.common.tag.TagExt;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;

public class TextCut
extends TagExt {
    private static final long serialVersionUID = 1L;
    private Object value;
    private Integer remainNum;
    private String symbol;
    private String arraySeparator;
    private String wrap;
    private String key;
    private boolean escape;
    private boolean cutPattern;

    @Override
    protected void init() {
        this.value = null;
        this.remainNum = 50;
        this.symbol = "...";
        this.arraySeparator = " ";
        this.key = null;
        this.wrap = null;
        this.cutPattern = false;
        this.escape = false;
        super.init();
    }

    public int doStartTag() throws JspException {
        if (this.value == null) {
            return 0;
        }
        String valStr = null;
        valStr = this.value.getClass().isArray() || this.value instanceof Collection ? DataConvert.arrayCollection2Str(this.value, this.arraySeparator, null, null, true, this.key) : DataConvert.Object2String(this.value, true, this.key);
        try {
            String newVal;
            String remainValue;
            if (this.cutPattern) {
                Pattern p = Pattern.compile("<[^>]+>");
                Matcher m = p.matcher(valStr);
                StringBuffer stringbuffer = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(stringbuffer, "");
                }
                m.appendTail(stringbuffer);
                valStr = stringbuffer.toString();
            }
            if ((remainValue = (valStr = StringUtils.trim((String)valStr))).length() > this.remainNum * 2) {
                remainValue = remainValue.substring(0, this.remainNum * 2 - 1);
            }
            remainValue = (newVal = remainValue.replaceAll("([^\\x00-\\xff])", "$1\u2299")).length() <= this.remainNum ? this.prepare(remainValue) : this.prepare(newVal.substring(0, this.remainNum).replaceAll("\u2299", "")) + this.symbol;
            if (this.wrap != null) {
                this.pageContext.getOut().append((CharSequence)this.wrap.replaceAll("\\{\\s*value\\s*\\}", valStr).replaceAll("\\{\\s*remainValue\\s*\\}", remainValue));
            } else {
                this.pageContext.getOut().append((CharSequence)remainValue);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"TextCut Tag processing error.", e);
        }
        return 1;
    }

    private String prepare(String value) {
        if (this.escape) {
            return TextUtils.htmlEncode(value);
        }
        return value;
    }

    public void setValue(Object value) {
        this.value = this.obtainVal(value, Object.class);
    }

    public void setRemainNum(Object remainNum) {
        this.remainNum = this.obtainVal(remainNum, Integer.class);
    }

    public void setSymbol(String symbol) {
        this.symbol = this.obtainVal(symbol, String.class);
    }

    public void setArraySeparator(String arraySeparator) {
        this.arraySeparator = arraySeparator;
    }

    public void setWrap(String wrap) {
        this.wrap = this.obtainVal(wrap, String.class);
    }

    public void setKey(String key) {
        this.key = this.obtainVal(key, String.class);
    }

    public void setEscape(Object escape) {
        this.escape = this.obtainVal(escape, Boolean.class);
    }

    public void setCutPattern(Object cutPattern) {
        this.cutPattern = this.obtainVal(cutPattern, Boolean.class);
    }
}

