/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.validate;

import com.easycodebox.common.enums.entity.LogLevel;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.error.ErrorContext;
import com.easycodebox.common.lang.CollectionUtils;
import com.easycodebox.common.lang.StringUtils;
import java.util.Collection;
import java.util.Map;

public class Assert {
    private static void throwException(boolean exp, String message, Object ... args) {
        if (exp) {
            throw new IllegalArgumentException(StringUtils.format(message, args));
        }
    }

    private static void throwError(boolean exp, String code, String message, Object ... args) {
        if (exp) {
            throw ErrorContext.instance(code, StringUtils.format(message, args), new Object[0]).logLevel(LogLevel.WARN);
        }
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "\u8868\u8fbe\u5f0f\u5fc5\u987b\u7b49\u4e8etrue", new Object[0]);
    }

    public static void isTrue(boolean expression, String message, Object ... args) {
        Assert.throwException(!expression, message, args);
    }

    public static void isTrue(boolean expression, CodeMsg error, Object ... args) {
        Assert.isTrue(expression, error.getCode(), error.getMsg(), args);
    }

    public static void isTrue(boolean expression, String code, String message, Object ... args) {
        Assert.throwError(!expression, code, message, args);
    }

    public static void isFalse(boolean expression) {
        Assert.isFalse(expression, "\u8868\u8fbe\u5f0f\u5fc5\u987b\u7b49\u4e8efalse", new Object[0]);
    }

    public static void isFalse(boolean expression, String message, Object ... args) {
        Assert.throwException(expression, message, args);
    }

    public static void isFalse(boolean expression, CodeMsg error, Object ... args) {
        Assert.isFalse(expression, error.getCode(), error.getMsg(), args);
    }

    public static void isFalse(boolean expression, String code, String message, Object ... args) {
        Assert.throwError(expression, code, message, args);
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "\u53c2\u6570\u5fc5\u987b\u4e3anull", new Object[0]);
    }

    public static void isNull(Object object, String message, Object ... args) {
        Assert.throwException(object != null, message, args);
    }

    public static void isNull(Object object, CodeMsg error, Object ... args) {
        Assert.isNull(object, error.getCode(), error.getMsg(), args);
    }

    public static void isNull(Object object, String code, String message, Object ... args) {
        Assert.throwError(object != null, code, message, args);
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "\u53c2\u6570\u4e0d\u80fd\u4e3anull", new Object[0]);
    }

    public static void notNull(Object object, String message, Object ... args) {
        Assert.throwException(object == null, message, args);
    }

    public static void notNull(Object object, CodeMsg error, Object ... args) {
        Assert.notNull(object, error.getCode(), error.getMsg(), args);
    }

    public static void notNull(Object object, String code, String message, Object ... args) {
        Assert.throwError(object == null, code, message, args);
    }

    public static void isBlank(String text) {
        Assert.isBlank(text, "\u53c2\u6570\u5e94\u4e3a\u7a7a\u6216\u7a7a\u683c\u5b57\u7b26", new Object[0]);
    }

    public static void isBlank(String text, String message, Object ... args) {
        Assert.throwException(!StringUtils.isBlank((String)text), message, args);
    }

    public static void isBlank(String text, CodeMsg error, Object ... args) {
        Assert.isBlank(text, error.getCode(), error.getMsg(), args);
    }

    public static void isBlank(String text, String code, String message, Object ... args) {
        Assert.throwError(!StringUtils.isBlank((String)text), code, message, args);
    }

    public static void notBlank(String text) {
        Assert.notBlank(text, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7a7a\u683c\u5b57\u7b26", new Object[0]);
    }

    public static void notBlank(String text, String message, Object ... args) {
        Assert.throwException(StringUtils.isBlank((String)text), message, args);
    }

    public static void notBlank(String text, CodeMsg error, Object ... args) {
        Assert.notBlank(text, error.getCode(), error.getMsg(), args);
    }

    public static void notBlank(String text, String code, String message, Object ... args) {
        Assert.throwError(StringUtils.isBlank((String)text), code, message, args);
    }

    public static void notContain(String textToSearch, String substring) {
        Assert.notContain(textToSearch, substring, "\u5b57\u7b26\u7a9c[" + textToSearch + "] \u4e0d\u80fd\u5305\u542b\u5b50\u5b57\u7b26\u7a9c[" + substring + "]", new Object[0]);
    }

    public static void notContain(String textToSearch, String substring, String message, Object ... args) {
        Assert.notNull(textToSearch);
        Assert.notNull(substring);
        Assert.throwException(textToSearch.indexOf(substring) != -1, message, args);
    }

    public static void notContain(String textToSearch, String substring, CodeMsg error, Object ... args) {
        Assert.notContain(textToSearch, substring, error.getCode(), error.getMsg(), args);
    }

    public static void notContain(String textToSearch, String substring, String code, String message, Object ... args) {
        Assert.notNull(textToSearch);
        Assert.notNull(substring);
        Assert.throwError(textToSearch.indexOf(substring) != -1, code, message, args);
    }

    public static void notEmpty(Object[] array) {
        Assert.notEmpty(array, "\u6570\u7ec4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
    }

    public static void notEmpty(Object[] array, String message, Object ... args) {
        Assert.throwException(array == null || array.length == 0, message, args);
    }

    public static void notEmpty(Object[] array, CodeMsg error, Object ... args) {
        Assert.notEmpty(array, error.getCode(), error.getMsg(), args);
    }

    public static void notEmpty(Object[] array, String code, String message, Object ... args) {
        Assert.throwError(array == null || array.length == 0, code, message, args);
    }

    public static void noNullElements(Object[] array) {
        Assert.noNullElements(array, "\u6570\u7ec4\u53c2\u6570\u4e0d\u5e94\u6709\u7a7a\u503c", new Object[0]);
    }

    public static void noNullElements(Object[] array, String message, Object ... args) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                Assert.throwException(true, message, args);
            }
        }
    }

    public static void noNullElements(Object[] array, CodeMsg error, Object ... args) {
        Assert.noNullElements(array, error.getCode(), error.getMsg(), args);
    }

    public static void noNullElements(Object[] array, String code, String message, Object ... args) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                Assert.throwError(true, code, message, args);
            }
        }
    }

    public static void length(Object[] array, int length) {
        Assert.length(array, length, "\u6570\u7ec4\u53c2\u6570\u957f\u5ea6\u5e94\u7b49\u4e8e" + length, new Object[0]);
    }

    public static void length(Object[] array, int length, String message, Object ... args) {
        Assert.throwException(array == null || array.length != length, message, args);
    }

    public static void length(Object[] array, int length, CodeMsg error, Object ... args) {
        Assert.length(array, length, error.getCode(), error.getMsg(), args);
    }

    public static void length(Object[] array, int length, String code, String message, Object ... args) {
        Assert.throwError(array == null || array.length != length, code, message, args);
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "\u96c6\u5408\u53c2\u6570\u81f3\u5c11\u6709\u4e00\u4e2a\u503c", new Object[0]);
    }

    public static void notEmpty(Collection<?> collection, String message, Object ... args) {
        Assert.throwException(CollectionUtils.isEmpty(collection), message, args);
    }

    public static void notEmpty(Collection<?> collection, CodeMsg error, Object ... args) {
        Assert.notEmpty(collection, error.getCode(), error.getMsg(), args);
    }

    public static void notEmpty(Collection<?> collection, String code, String message, Object ... args) {
        Assert.throwError(CollectionUtils.isEmpty(collection), code, message, args);
    }

    public static void notEmpty(Map<?, ?> map) {
        Assert.notEmpty(map, "map\u81f3\u5c11\u6709\u4e00\u4e2a\u503c", new Object[0]);
    }

    public static void notEmpty(Map<?, ?> map, String message, Object ... args) {
        Assert.throwException(map == null || map.isEmpty(), message, args);
    }

    public static void notEmpty(Map<?, ?> map, CodeMsg error, Object ... args) {
        Assert.notEmpty(map, error.getCode(), error.getMsg(), args);
    }

    public static void notEmpty(Map<?, ?> map, String code, String message, Object ... args) {
        Assert.throwError(map == null || map.isEmpty(), code, message, args);
    }

    public static void isInstanceOf(Class<?> clazz, Object obj) {
        Assert.isInstanceOf(clazz, obj, "\u7c7b [" + (obj != null ? obj.getClass().getName() : "null") + "] \u5fc5\u987b\u662f " + clazz + "\u7684\u4e00\u4e2a\u5b9e\u4f8b", new Object[0]);
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message, Object ... args) {
        Assert.notNull(type, "type\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u503c", new Object[0]);
        Assert.throwException(!type.isInstance(obj), message, args);
    }

    public static void isInstanceOf(Class<?> clazz, Object obj, CodeMsg error, Object ... args) {
        Assert.isInstanceOf(clazz, obj, error.getCode(), error.getMsg(), args);
    }

    public static void isInstanceOf(Class<?> type, Object obj, String code, String message, Object ... args) {
        Assert.notNull(type, "type\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u503c", new Object[0]);
        Assert.throwError(!type.isInstance(obj), code, message, args);
    }

    public static void isAssignable(Class superType, Class subType) {
        Assert.isAssignable(superType, subType, subType + " is not assignable to " + superType, new Object[0]);
    }

    public static void isAssignable(Class superType, Class subType, String message, Object ... args) {
        Assert.notNull((Object)superType, "superType\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u503c", new Object[0]);
        Assert.throwException(subType == null || !superType.isAssignableFrom(subType), message, args);
    }

    public static void isAssignable(Class superType, Class subType, CodeMsg error, Object ... args) {
        Assert.isAssignable(superType, subType, error.getCode(), error.getMsg(), args);
    }

    public static void isAssignable(Class superType, Class subType, String code, String message, Object ... args) {
        Assert.notNull((Object)superType, "superType\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u503c", new Object[0]);
        Assert.throwError(subType == null || !superType.isAssignableFrom(subType), code, message, args);
    }
}

