/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.validate;

import com.easycodebox.common.enums.entity.LogLevel;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.error.ErrorContext;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.validate.Regex;
import com.easycodebox.common.validate.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validators
implements Serializable {
    private static final long serialVersionUID = 4413832001725624691L;
    private transient Object data;
    private transient String identify;
    private transient boolean throwError;
    private transient boolean verifyEnd = false;
    private Boolean valid;
    private String msg;

    public static Validators instance(Object data) {
        return Validators.instance(null, data, true);
    }

    public static Validators instance(Object data, boolean throwError) {
        return Validators.instance(null, data, throwError);
    }

    public static Validators instance(String identify, Object data) {
        return Validators.instance(identify, data, true);
    }

    public static Validators instance(String identify, Object data, boolean throwError) {
        return new Validators(identify, data, throwError);
    }

    private Validators(String identify, Object data, boolean throwError) {
        this.identify = identify;
        this.data = data;
        this.throwError = throwError;
    }

    private boolean invalid() {
        return this.valid != null && this.valid == false;
    }

    private boolean jumpValidate() {
        return this.invalid() && !this.verifyEnd;
    }

    private String resetMsg(String reset, String ... msg) {
        if (msg == null || msg.length == 0) {
            return reset;
        }
        return msg[0];
    }

    private Validators result(boolean valid, String msg) {
        if (this.valid == null || this.valid.booleanValue()) {
            this.valid = valid;
        }
        if (this.valid != null && !this.valid.booleanValue() && msg != null && StringUtils.isNotBlank((String)msg)) {
            this.msg = StringUtils.isNotBlank((String)this.msg) ? this.msg + msg + " " : msg + " ";
        }
        if (this.throwError && !valid) {
            throw ErrorContext.instance(CodeMsg.Code.FAIL_CODE, this.msg, new Object[0]).logLevel(LogLevel.WARN);
        }
        return this;
    }

    public Validators validate(Validator validator, String ... msg) {
        if (!this.jumpValidate()) {
            this.result(validator.validate(this.data), this.resetMsg(null, msg));
        }
        return this;
    }

    public Validators regex(Regex regex, String ... msg) {
        if (!this.jumpValidate()) {
            Pattern p;
            Matcher m;
            boolean va = false;
            if (this.data != null && regex != null && (m = (p = Pattern.compile(regex.getRegex())).matcher(this.data.toString())).find()) {
                va = true;
            }
            this.result(va, this.resetMsg(regex.getMsg(), msg));
        }
        return this;
    }

    public Validators regex(Regex regex, int flags, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va;
            if (this.data == null || regex == null) {
                va = false;
            } else {
                Pattern p = Pattern.compile(regex.getRegex(), flags);
                Matcher m = p.matcher(this.data.toString());
                va = m.matches();
            }
            this.result(va, this.resetMsg(regex.getMsg(), msg));
        }
        return this;
    }

    public Validators regex(String regex, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = this.data == null || regex == null ? false : Pattern.matches(regex, this.data.toString());
            this.result(va, this.resetMsg(null, msg));
        }
        return this;
    }

    public Validators regex(String regex, int flags, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va;
            if (this.data == null || regex == null) {
                va = false;
            } else {
                Pattern p = Pattern.compile(regex, flags);
                Matcher m = p.matcher(this.data.toString());
                va = m.matches();
            }
            this.result(va, this.resetMsg(null, msg));
        }
        return this;
    }

    public Validators equalTo(Object obj, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = this.data == null && obj == null ? true : (this.data == null && obj != null ? false : this.data.equals(obj));
            this.result(va, this.resetMsg(null, msg));
        }
        return this;
    }

    public Validators differs(Object obj, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = this.data == null && obj == null ? false : (this.data == null && obj != null ? true : !this.data.equals(obj));
            this.result(va, this.resetMsg(null, msg));
        }
        return this;
    }

    public Validators nulls(String ... msg) {
        if (!this.jumpValidate()) {
            this.result(this.data == null, this.resetMsg("{0}\u53ea\u80fd\u4e3aNULL", msg));
        }
        return this;
    }

    public Validators notNull(String ... msg) {
        if (!this.jumpValidate()) {
            this.result(this.data != null, this.resetMsg("{0}\u4e0d\u80fd\u4e3aNULL", msg));
        }
        return this;
    }

    public Validators notNullInside(String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = true;
            if (this.data == null) {
                va = false;
            } else if (this.data.getClass().isArray()) {
                Object[] tmp;
                for (Object o : tmp = (Object[])this.data) {
                    if (o != null) continue;
                    va = false;
                    break;
                }
            } else if (this.data instanceof Collection) {
                Collection tmp = (Collection)this.data;
                Iterator ite = tmp.iterator();
                while (ite.hasNext()) {
                    if (ite.next() != null) continue;
                    va = false;
                    break;
                }
            } else if (this.data instanceof Map) {
                Map tmp = (Map)this.data;
                Collection vals = tmp.values();
                Iterator ite = vals.iterator();
                while (ite.hasNext()) {
                    if (ite.next() != null) continue;
                    va = false;
                    break;
                }
            }
            this.result(va, this.resetMsg("{0}\u6570\u7ec4\u5185\u90e8\u4e0d\u80fd\u51fa\u73b0null\u503c", msg));
        }
        return this;
    }

    public Validators empty(String ... msg) {
        if (!this.jumpValidate()) {
            this.result(this.data == null || StringUtils.isBlank((String)this.data.toString()), this.resetMsg("{0}\u53ea\u80fd\u4e3a\u7a7a", msg));
        }
        return this;
    }

    public Validators notEmpty(String ... msg) {
        if (!this.jumpValidate()) {
            this.result(this.data != null && StringUtils.isNotBlank((String)this.data.toString()), this.resetMsg("{0}\u4e0d\u80fd\u4e3a\u7a7a", msg));
        }
        return this;
    }

    public Validators notEmptyInside(String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = true;
            if (this.data == null || StringUtils.isBlank((String)this.data.toString())) {
                va = false;
            } else if (this.data.getClass().isArray()) {
                Object[] tmp;
                for (Object o : tmp = (Object[])this.data) {
                    if (o != null && !StringUtils.isBlank((String)o.toString())) continue;
                    va = false;
                    break;
                }
            } else if (this.data instanceof Collection) {
                Collection tmp = (Collection)this.data;
                for (Object o : tmp) {
                    if (o != null && !StringUtils.isBlank((String)o.toString())) continue;
                    va = false;
                    break;
                }
            } else if (this.data instanceof Map) {
                Map tmp = (Map)this.data;
                Collection vals = tmp.values();
                for (Object o : vals) {
                    if (o != null && !StringUtils.isBlank((String)o.toString())) continue;
                    va = false;
                    break;
                }
            }
            this.result(va, this.resetMsg("{0}\u6570\u7ec4\u5185\u90e8\u4e0d\u80fd\u51fa\u73b0\u7a7a\u503c", msg));
        }
        return this;
    }

    public Validators minLength(int min, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = false;
            if (this.data != null && (this.data instanceof String && ((String)this.data).length() >= min || this.data.getClass().isArray() && ((Object[])this.data).length >= min || this.data instanceof Collection && ((Collection)this.data).size() >= min || this.data instanceof Map && ((Map)this.data).size() >= min)) {
                va = true;
            }
            this.result(va, this.resetMsg("{0}\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + min, msg));
        }
        return this;
    }

    public Validators maxLength(int max, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = true;
            if (this.data != null && (this.data instanceof String && ((String)this.data).length() > max || this.data.getClass().isArray() && ((Object[])this.data).length > max || this.data instanceof Collection && ((Collection)this.data).size() > max || this.data instanceof Map && ((Map)this.data).size() > max)) {
                va = false;
            }
            this.result(va, this.resetMsg("{0}\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + max, msg));
        }
        return this;
    }

    public Validators rangeLength(int min, int max, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = false;
            if (this.data != null && (this.data instanceof String && ((String)this.data).length() >= min && ((String)this.data).length() <= max || this.data.getClass().isArray() && ((Object[])this.data).length >= min && ((Object[])this.data).length <= max || this.data instanceof Collection && ((Collection)this.data).size() >= min && ((Collection)this.data).size() <= max || this.data instanceof Map && ((Map)this.data).size() >= min && ((Map)this.data).size() <= max)) {
                va = true;
            }
            this.result(va, this.resetMsg("{0}\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + max, msg));
        }
        return this;
    }

    public Validators min(Number min, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = false;
            if (this.data != null) {
                if (this.data instanceof String) {
                    if (Pattern.matches(Regex.DECEMAL.getRegex(), this.data.toString())) {
                        double value = Double.valueOf(this.data.toString());
                        va = value >= min.doubleValue();
                    }
                } else if (this.data.getClass().isPrimitive() || this.data instanceof Number) {
                    double value = ((Number)this.data).doubleValue();
                    va = value >= min.doubleValue();
                }
            }
            this.result(va, this.resetMsg("{0}\u6570\u503c\u4e0d\u80fd\u5c0f\u4e8e" + min, msg));
        }
        return this;
    }

    public Validators max(Number max, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = false;
            if (this.data != null) {
                if (this.data instanceof String) {
                    if (Pattern.matches(Regex.DECEMAL.getRegex(), this.data.toString())) {
                        double value = Double.valueOf(this.data.toString());
                        va = value <= max.doubleValue();
                    }
                } else if (this.data.getClass().isPrimitive() || this.data instanceof Number) {
                    double value = ((Number)this.data).doubleValue();
                    va = value <= max.doubleValue();
                }
            }
            this.result(va, this.resetMsg("{0}\u6570\u503c\u4e0d\u80fd\u5927\u4e8e" + max, msg));
        }
        return this;
    }

    public Validators between(Number min, Number max, String ... msg) {
        if (!this.jumpValidate()) {
            boolean va = false;
            if (this.data != null) {
                if (this.data instanceof String) {
                    if (Pattern.matches(Regex.DECEMAL.getRegex(), this.data.toString())) {
                        double value = Double.valueOf(this.data.toString());
                        va = value >= min.doubleValue() && value <= max.doubleValue();
                    }
                } else if (this.data.getClass().isPrimitive() || this.data instanceof Number) {
                    double value = ((Number)this.data).doubleValue();
                    va = value >= min.doubleValue() && value <= max.doubleValue();
                }
            }
            this.result(va, this.resetMsg("{0}\u6570\u503c\u5fc5\u987b\u4f4d\u4e8e" + min + "-" + max + "\u4e4b\u95f4", msg));
        }
        return this;
    }

    public Validators num(String ... msg) {
        return this.regex(Regex.NUM, msg);
    }

    public Validators chinese(String ... msg) {
        return this.regex(Regex.CHINESE, msg);
    }

    public Validators anyChinese(String ... msg) {
        return this.regex(Regex.ANY_CHINESE, msg);
    }

    public Validators email(String ... msg) {
        return this.regex(Regex.EMAIL, msg);
    }

    public Validators url(String ... msg) {
        return this.regex(Regex.URL, msg);
    }

    public Validators word(String ... msg) {
        return this.regex(Regex.WORD, msg);
    }

    public Validators wordZh(String ... msg) {
        return this.regex(Regex.WORD_ZH, msg);
    }

    public Validators mobile(String ... msg) {
        return this.regex(Regex.MOBILE, msg);
    }

    public Validators idcard(String ... msg) {
        return this.regex(Regex.IDCARD, msg);
    }

    public Validators tel(String ... msg) {
        return this.regex(Regex.TEL, msg);
    }

    public Validators decemal(String ... msg) {
        return this.regex(Regex.DECEMAL, msg);
    }

    public Boolean isValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public String getRawMsg() {
        return this.msg;
    }

    public String getMsg() {
        return StringUtils.format(this.msg, this.identify);
    }

    public CodeMsg getError() {
        return (this.isValid() != false ? CodeMsg.SUC : CodeMsg.FAIL).msg(this.getMsg(), new Object[0]);
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isVerifyEnd() {
        return this.verifyEnd;
    }

    public Validators setVerifyEnd(boolean verifyEnd) {
        this.verifyEnd = verifyEnd;
        return this;
    }

    public boolean isThrowError() {
        return this.throwError;
    }

    public Validators setThrowError(boolean throwError) {
        this.throwError = throwError;
        return this;
    }

    public static void main(String[] args) {
        System.out.println(Pattern.matches("[12.]", "6"));
    }
}

