/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.web;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.web.CacheHisUri;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Deprecated
public class CacheHisUris {
    private static final Logger LOG = LoggerFactory.getLogger(CacheHisUris.class);
    public static final String CACHE_HIS_URI_KEY = "cached_his_uri";
    public static final String FLUSH_CACHED_URI = "flush_cached_uri";
    public static final String BACK_CACHED_URI = "back_cached_uri";
    public static final String CUR_URI = "curUri";
    public static final String BACK_URI = "backUri";
    public static final int CACHE_NUM = 10;
    private static ConcurrentHashMap<String, Boolean> uris = new ConcurrentHashMap();

    public static boolean isCacheHisMethod(Method method) {
        String key = method.toGenericString();
        boolean exist = uris.containsKey(key);
        if (!exist) {
            CacheHisUri his = method.getAnnotation(CacheHisUri.class);
            if (his != null) {
                uris.putIfAbsent(key, Boolean.TRUE);
                exist = true;
            } else {
                uris.putIfAbsent(key, Boolean.FALSE);
            }
        } else {
            exist = uris.get(key);
        }
        return exist;
    }

    public static boolean cacheHisUri(Method method, HttpServletRequest request) {
        boolean isCacheUri = CacheHisUris.isCacheHisMethod(method);
        try {
            HttpSession session = request.getSession();
            ArrayList<String> uris = (ArrayList<String>)session.getAttribute(CACHE_HIS_URI_KEY);
            if (uris == null) {
                uris = new ArrayList<String>(10);
                session.setAttribute(CACHE_HIS_URI_KEY, uris);
            }
            if (isCacheUri) {
                if (request.getQueryString() == null || !request.getQueryString().contains(FLUSH_CACHED_URI) && !request.getQueryString().contains(BACK_CACHED_URI)) {
                    while (uris.size() >= 10) {
                        uris.remove(0);
                    }
                    String fullUri = HttpUtils.getFullRequestUri(request, true, new String[0]);
                    uris.add(fullUri);
                    LOG.debug((Object)"cache hisUri = {0}", fullUri);
                } else if (request.getQueryString().contains(BACK_CACHED_URI)) {
                    uris.remove(uris.size() - 1);
                }
                String curUri = uris == null || uris.size() == 0 ? "" : (String)uris.get(uris.size() - 1);
                String backUri = uris == null || uris.size() < 2 ? "" : (String)uris.get(uris.size() - 2);
                request.setAttribute(CUR_URI, (Object)curUri);
                request.setAttribute(BACK_URI, (Object)backUri);
            } else {
                String backUri = uris == null || uris.size() == 0 ? "" : (String)uris.get(uris.size() - 1);
                request.setAttribute(BACK_URI, (Object)backUri);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"CacheHisUri error.", e);
        }
        return isCacheUri;
    }
}

