/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.web.callback;

import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;

public class CallbackData
extends CodeMsg {
    private static final long serialVersionUID = -1580285521851719262L;
    private static final transient Logger LOG = LoggerFactory.getLogger(CallbackData.class);
    private String action;
    private String url;

    public static CallbackData instance() {
        return CallbackData.instance(null, null, null, null);
    }

    public static CallbackData instance(String code) {
        return CallbackData.instance(null, code, null, null);
    }

    public static CallbackData instance(String code, String msg) {
        return CallbackData.instance(null, code, msg, null);
    }

    public static CallbackData instance(String action, String code, String msg) {
        return CallbackData.instance(action, code, msg, null);
    }

    public static CallbackData instance(String action, String code, String msg, String url) {
        return new CallbackData(code, msg).setAction(action).setUrl(url);
    }

    public static CallbackData instance(CodeMsg codeMsg) {
        return CallbackData.instance(null, codeMsg, null);
    }

    public static CallbackData instance(String action, CodeMsg codeMsg) {
        return CallbackData.instance(action, codeMsg, null);
    }

    public static CallbackData instance(String action, CodeMsg codeMsg, String url) {
        return new CallbackData(codeMsg == null ? null : codeMsg.getCode(), codeMsg == null ? null : codeMsg.getMsg(), codeMsg == null ? null : codeMsg.getData()).setAction(action).setUrl(url);
    }

    private CallbackData(String code, String msg) {
        super(code, msg);
    }

    private CallbackData(String code, String msg, Object data) {
        super(code, msg, data);
    }

    public boolean eqcode(String code) {
        return code == null && this.getCode() == null || code != null && code.equals(this.getCode());
    }

    @Override
    public String toString() {
        String msg = this.getMsg();
        msg = StringUtils.isBlank((String)msg) ? null : StringUtils.string2unicode(msg);
        StringBuilder sb = new StringBuilder().append("{").append("\"action\"").append(":").append(StringUtils.valueToString(this.getAction())).append(",").append("\"code\"").append(":").append(StringUtils.valueToString(this.getCode())).append(",").append("\"msg\"").append(":").append(StringUtils.valueToString(msg)).append(",").append("\"url\"").append(":").append(StringUtils.valueToString(this.getUrl()));
        try {
            sb.append(",").append("\"data\"").append(":").append(Jacksons.COMMUNICATE.toJson(this.getData()));
        }
        catch (Exception e) {
            LOG.error((Object)"\u89e3\u6790JSON\u9519\u8bef", e);
        }
        sb.append("}");
        return sb.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public CallbackData setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public CallbackData setAction(String action) {
        this.action = action;
        return this;
    }
}

