/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.web.springmvc;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.web.CacheHisUris;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class DataInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DataInterceptor.class);
    private boolean basePath = true;
    private final String BASE_PATH_KEY = "basePath";
    private boolean imgUrl = true;
    private final String IMG_URL_KEY = "imgUrl";
    private boolean cacheHisUri = false;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        if (modelAndView != null) {
            if (this.basePath) {
                modelAndView.addObject("basePath", (Object)(BaseConstants.basePath == null ? (BaseConstants.basePath = HttpUtils.getBasePath(request)) : BaseConstants.basePath));
            }
            if (this.imgUrl) {
                if (StringUtils.isBlank((String)BaseConstants.imgUrl)) {
                    LOG.warn("Has no config IMG_URL constant.");
                } else {
                    modelAndView.addObject("imgUrl", (Object)BaseConstants.imgUrl);
                }
            }
        }
        if (this.cacheHisUri) {
            CacheHisUris.cacheHisUri(handlerMethod.getMethod(), request);
        }
    }

    public void setImgUrl(boolean imgUrl) {
        this.imgUrl = imgUrl;
    }

    public void setBasePath(boolean basePath) {
        this.basePath = basePath;
    }

    @Deprecated
    public void setCacheHisUri(boolean cacheHisUri) {
        this.cacheHisUri = cacheHisUri;
    }
}

