/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.web.springmvc;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.error.ErrorContext;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.web.callback.Callbacks;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class DefaultMappingExceptionResolver
extends SimpleMappingExceptionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMappingExceptionResolver.class);
    private String exceptionAttribute = "exception";
    public static final String MSG_ATTR = "msg";

    public ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        CodeMsg error = null;
        if (ex instanceof ErrorContext) {
            error = ((ErrorContext)ex).getError();
            if (StringUtils.isBlank((String)error.getCode())) {
                error.code(CodeMsg.Code.FAIL_CODE);
            }
        } else {
            error = CodeMsg.FAIL;
        }
        if (HttpUtils.isAjaxRequest(request)) {
            response.setContentType("application/json;charset=UTF-8");
            try {
                JsonGenerator jsonGenerator = Jacksons.NON_NULL.getFactory().createGenerator((Writer)response.getWriter());
                Jacksons.NON_NULL.writeValue(jsonGenerator, error);
                return null;
            }
            catch (Exception jsonEx) {
                throw new BaseException("Could not write JSON: " + jsonEx.getMessage(), (Throwable)jsonEx, new Object[0]);
            }
        }
        if (request.getParameter(BaseConstants.DIALOG_REQ) != null) {
            Callbacks.callback(Callbacks.none(error), null, response);
            return null;
        }
        LOG.error((Object)"Execute controller error.", ex);
        return super.doResolveException(request, response, handler, ex);
    }

    protected String determineViewName(Exception ex, HttpServletRequest request) {
        Object responseUrl = request.getAttribute(BaseConstants.responseUrlKey);
        if (responseUrl != null) {
            return responseUrl.toString();
        }
        return super.determineViewName(ex, request);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex) {
        ModelAndView mv = new ModelAndView(viewName);
        if (this.exceptionAttribute != null) {
            mv.addObject(this.exceptionAttribute, (Object)ex);
        }
        String errorMsg = CodeMsg.Msg.FAIL_MSG_INFO;
        if (ex instanceof ErrorContext) {
            CodeMsg error = ((ErrorContext)ex).getError();
            errorMsg = StringUtils.isBlank((String)error.getMsg()) ? errorMsg : error.getMsg();
        }
        mv.addObject(MSG_ATTR, (Object)errorMsg);
        return mv;
    }
}

