/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.web.springmvc;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class DefaultRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestMappingHandlerMapping.class);
    private String defaultMethod = "execute";
    private String controllerPostfix;
    private String[] excludePatterns;
    private ConcurrentHashMap<String, HandlerMethod> handlerCache = new ConcurrentHashMap();
    private ConcurrentSkipListSet<String> noHandlerCache = new ConcurrentSkipListSet();
    private AtomicInteger counter = new AtomicInteger();
    private final int maxCount = 512;

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        if (this.isExclude(this.excludePatterns, lookupPath)) {
            return null;
        }
        HandlerMethod handlerMethod = super.lookupHandlerMethod(lookupPath, request);
        if (handlerMethod == null) {
            int index = lookupPath.lastIndexOf(".");
            if (index > -1) {
                lookupPath = lookupPath.substring(0, index);
            }
            if (this.handlerCache.containsKey(lookupPath)) {
                return this.handlerCache.get(lookupPath);
            }
        }
        if (handlerMethod == null && lookupPath.length() > 0) {
            RequestMapping typeAnnotation;
            if (this.noHandlerCache.contains(lookupPath)) {
                return null;
            }
            boolean startSlash = lookupPath.charAt(0) == '/';
            String[] paths = (startSlash ? lookupPath.substring(1) : lookupPath).split("/");
            String className = null;
            String methodName = null;
            if (paths.length == 0 || paths.length > 2) {
                this.addNoHandlerCache(lookupPath);
                return null;
            }
            if (paths.length == 1) {
                className = this.getControllerName(paths[0]);
                methodName = this.defaultMethod;
            } else if (paths.length == 2) {
                className = this.getControllerName(paths[0]);
                methodName = paths[1];
            }
            Object controller = null;
            Method method = null;
            if (this.getApplicationContext().containsBean(className)) {
                try {
                    controller = this.getApplicationContext().getBean(className);
                }
                catch (Exception e) {
                    LOG.error((Object)"Obtain bean [{0}] error.", e, className);
                }
            }
            if (controller == null || !this.isHandler(controller.getClass())) {
                this.addNoHandlerCache(lookupPath);
                return null;
            }
            method = this.findMehtod(controller.getClass(), methodName);
            if (method == null) {
                this.addNoHandlerCache(lookupPath);
                return null;
            }
            RequestMappingInfo info = null;
            RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            if (methodAnnotation != null) {
                RequestCondition methodCondition = this.getCustomMethodCondition(method);
                info = this.createRequestMappingInfo(lookupPath, methodAnnotation, methodCondition);
            }
            if ((typeAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(controller.getClass(), RequestMapping.class)) != null) {
                RequestCondition typeCondition = this.getCustomTypeCondition(controller.getClass());
                info = info == null ? this.createRequestMappingInfo(lookupPath, typeAnnotation, typeCondition) : this.createRequestMappingInfo(null, typeAnnotation, typeCondition).combine(info);
            }
            if (info == null) {
                info = new RequestMappingInfo(null, null, null, null, null, null, null);
            }
            this.handleMatch(info, lookupPath, request);
            HandlerMethod handler = new HandlerMethod(controller, method);
            this.handlerCache.putIfAbsent(lookupPath, handler);
            return handler;
        }
        return handlerMethod;
    }

    private boolean addNoHandlerCache(String lookupPath) {
        String val;
        int count;
        boolean suc = this.noHandlerCache.add(lookupPath);
        if (suc && (count = this.counter.incrementAndGet()) > 512 && (val = this.noHandlerCache.pollFirst()) != null) {
            this.counter.decrementAndGet();
        }
        return suc;
    }

    private Method findMehtod(Class<?> clazz, String methodName) {
        Method method;
        block4: {
            method = null;
            try {
                while (!clazz.equals(Object.class)) {
                    Method[] methods;
                    for (Method me : methods = clazz.getDeclaredMethods()) {
                        if (!Modifier.isPublic(me.getModifiers()) || !me.getName().equals(methodName)) continue;
                        method = me;
                        break block4;
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    private String getControllerName(String forShort) {
        return this.controllerPostfix == null ? forShort : forShort + this.controllerPostfix;
    }

    private RequestMappingInfo createRequestMappingInfo(String lookupPath, RequestMapping annotation, RequestCondition<?> customCondition) {
        String[] stringArray;
        if (lookupPath == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lookupPath;
        }
        String[] patterns = stringArray;
        return new RequestMappingInfo(new PatternsRequestCondition(patterns, this.getUrlPathHelper(), this.getPathMatcher(), this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), this.getFileExtensions()), new RequestMethodsRequestCondition(annotation.method()), new ParamsRequestCondition(annotation.params()), new HeadersRequestCondition(annotation.headers()), new ConsumesRequestCondition(annotation.consumes(), annotation.headers()), new ProducesRequestCondition(annotation.produces(), annotation.headers(), this.getContentNegotiationManager()), customCondition);
    }

    private boolean isExclude(String[] excludePatterns, String lookupPath) {
        if (excludePatterns == null || excludePatterns.length == 0) {
            return false;
        }
        for (String pattern : excludePatterns) {
            if (pattern.equals(lookupPath)) {
                return true;
            }
            if (this.useSuffixPatternMatch()) {
                if (this.getFileExtensions() != null && !this.getFileExtensions().isEmpty() && lookupPath.indexOf(46) != -1) {
                    for (String extension : this.getFileExtensions()) {
                        if (!this.getPathMatcher().match(pattern + extension, lookupPath)) continue;
                        return true;
                    }
                } else {
                    boolean hasSuffix;
                    boolean bl = hasSuffix = pattern.indexOf(46) != -1;
                    if (!hasSuffix && this.getPathMatcher().match(pattern + ".*", lookupPath)) {
                        return true;
                    }
                }
            }
            if (this.getPathMatcher().match(pattern, lookupPath)) {
                return true;
            }
            boolean endsWithSlash = pattern.endsWith("/");
            if (!this.useTrailingSlashMatch() || endsWithSlash || !this.getPathMatcher().match(pattern + "/", lookupPath)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultMethod(String defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    public void setControllerPostfix(String controllerPostfix) {
        this.controllerPostfix = controllerPostfix;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }
}

