/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.web.springmvc;

import com.easycodebox.common.enums.Enums;
import com.easycodebox.common.validate.Assert;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class StringToEnumConverterFactory
implements ConverterFactory<String, Enum<?>> {
    public <T extends Enum<?>> Converter<String, T> getConverter(Class<T> targetType) {
        Class<T> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, "The target type does not refer to an enum", targetType);
        return new StringToDetailEnumConverter<T>(enumType);
    }

    public static class StringToDetailEnumConverter<T extends Enum<?>>
    implements Converter<String, T> {
        private Class<T> enumType;

        public StringToDetailEnumConverter(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(String source) {
            Assert.isTrue(this.enumType.isEnum(), "{0} class is not enum, so can not convert {1} to enum.", this.enumType, source);
            return (T)((Enum)Enums.deserialize(this.enumType, source, true));
        }
    }
}

